/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.libpam.impl;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import org.jvnet.libpam.PAMException;
import org.jvnet.libpam.impl.BSDCLibrary;
import org.jvnet.libpam.impl.LinuxCLibrary;
import org.jvnet.libpam.impl.SolarisCLibrary;

public interface CLibrary
extends Library {
    public static final CLibrary libc = Instance.access$000();

    public Pointer calloc(int var1, int var2);

    public Pointer strdup(String var1);

    public passwd getpwnam(String var1);

    public int getgrouplist(String var1, int var2, Memory var3, IntByReference var4);

    public int _getgroupsbymember(String var1, Memory var2, int var3, int var4);

    public group getgrgid(int var1);

    public group getgrnam(String var1);

    public static class Instance {
        private static CLibrary init() {
            if (Platform.isMac() || Platform.isFreeBSD() || Platform.isOpenBSD()) {
                return (CLibrary)Native.loadLibrary((String)"c", BSDCLibrary.class);
            }
            if (Platform.isSolaris()) {
                return (CLibrary)Native.loadLibrary((String)"c", SolarisCLibrary.class);
            }
            if (Platform.isLinux()) {
                return (CLibrary)Native.loadLibrary((String)"c", LinuxCLibrary.class);
            }
            return (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);
        }

        static /* synthetic */ CLibrary access$000() {
            return Instance.init();
        }
    }

    public static class group
    extends Structure {
        public String gr_name;
    }

    public static class passwd
    extends Structure {
        public String pw_name;
        public String pw_passwd;
        public int pw_uid;
        public int pw_gid;

        public static passwd loadPasswd(String userName) throws PAMException {
            passwd pwd = libc.getpwnam(userName);
            if (pwd == null) {
                throw new PAMException("No user information is available");
            }
            return pwd;
        }

        public String getPwName() {
            return this.pw_name;
        }

        public String getPwPasswd() {
            return this.pw_passwd;
        }

        public int getPwUid() {
            return this.pw_uid;
        }

        public int getPwGid() {
            return this.pw_gid;
        }

        public String getPwGecos() {
            return null;
        }

        public String getPwDir() {
            return null;
        }

        public String getPwShell() {
            return null;
        }
    }
}

