/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.Action;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildParametersColumn
extends ListViewColumn {
    private boolean singlePara;
    private String parameterName;

    @DataBoundConstructor
    public BuildParametersColumn(boolean singlePara, String parameterName) {
        this.singlePara = singlePara;
        this.parameterName = parameterName;
    }

    public BuildParametersColumn() {
        this(false, "");
    }

    public boolean isSinglePara() {
        return this.singlePara;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getBuildParameters(Job<?, ?> job) {
        if (job == null || job.getLastBuild() == null) {
            return "";
        }
        Run r = job.getLastBuild();
        StringBuilder s = new StringBuilder();
        for (Action action : r.getAllActions()) {
            if (!(action instanceof ParametersAction)) continue;
            ParametersAction pa = (ParametersAction)action;
            for (ParameterValue p : pa.getParameters()) {
                if (this.isSinglePara() && !p.getName().equalsIgnoreCase(this.parameterName)) continue;
                s.append(p.getShortDescription()).append("<br/>");
            }
        }
        return s.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.BuildParametersColumn_DisplayName();
        }
    }
}

