/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.model.ViewJob;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobTypeColumn
extends ListViewColumn {
    private boolean usePronoun;

    @DataBoundConstructor
    public JobTypeColumn(boolean usePronoun) {
        this.usePronoun = usePronoun;
    }

    public JobTypeColumn() {
        this(false);
    }

    public boolean isUsePronoun() {
        return this.usePronoun;
    }

    public String getJobType(AbstractItem item) {
        if (this.isUsePronoun()) {
            return item.getPronoun();
        }
        return this.getSimpleName(item);
    }

    private String getSimpleName(AbstractItem item) {
        String simpleName = item.getClass().getSimpleName();
        if ("Folder".equals(simpleName)) {
            return Messages.JobTypeColumn_FolderName();
        }
        if ("MavenModuleSet".equals(simpleName)) {
            return Messages.JobTypeColumn_MavenName();
        }
        if ("MultiJobProject".equals(simpleName)) {
            return Messages.JobTypeColumn_MultiJobName();
        }
        if ("IvyModuleSet".equals(simpleName)) {
            return Messages.JobTypeColumn_IvyName();
        }
        if ("MatrixProject".equals(simpleName)) {
            return Messages.JobTypeColumn_MultiConfigName();
        }
        if ("FreeStyleProject".equals(simpleName)) {
            return Messages.JobTypeColumn_FreestyleName();
        }
        if ("WorkflowJob".equals(simpleName)) {
            return Messages.JobTypeColumn_WorkflowJobName();
        }
        if ("WorkflowMultiBranchProject".equals(simpleName)) {
            return Messages.JobTypeColumn_WorkflowMultiBranchProjectName();
        }
        if (item instanceof ViewJob) {
            return Messages.JobTypeColumn_ExternalName();
        }
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.JobTypeColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

