/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.cli.auth.ssh;

import com.trilead.ssh2.crypto.Base64;
import com.trilead.ssh2.packets.TypesWriter;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.RSAPublicKey;

public class PublicKeySignatureWriter {
    public String asString(PublicKey key) {
        if (key instanceof RSAPublicKey) {
            return this.asString((RSAPublicKey)key);
        }
        if (key instanceof DSAPublicKey) {
            return this.asString((DSAPublicKey)key);
        }
        throw new IllegalArgumentException("Unknown key type: " + key);
    }

    public String asString(DSAPublicKey key) {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-dss");
        DSAParams p = key.getParams();
        tw.writeMPInt(p.getP());
        tw.writeMPInt(p.getQ());
        tw.writeMPInt(p.getG());
        tw.writeMPInt(key.getY());
        return this.encode(tw);
    }

    public String asString(RSAPublicKey key) {
        TypesWriter tw = new TypesWriter();
        tw.writeString("ssh-rsa");
        tw.writeMPInt(key.getPublicExponent());
        tw.writeMPInt(key.getModulus());
        return this.encode(tw);
    }

    private String encode(TypesWriter tw) {
        return new String(Base64.encode((byte[])tw.getBytes()));
    }
}

