/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.util.ContextHashCode;
import hudson.plugins.analysis.util.model.AbstractAnnotation;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class AbstractAnnotationParser
implements AnnotationParser {
    private static final long serialVersionUID = 4014720188570415914L;
    private final String defaultEncoding;

    protected AbstractAnnotationParser(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected final String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @Override
    public Collection<FileAnnotation> parse(File file, String moduleName) throws InvocationTargetException {
        Collection<FileAnnotation> collection;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            collection = this.intern(this.parse(input, moduleName));
        }
        catch (FileNotFoundException exception) {
            try {
                throw new InvocationTargetException(exception);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return collection;
    }

    protected Collection<FileAnnotation> intern(Collection<FileAnnotation> annotations) {
        return AbstractAnnotation.intern(annotations);
    }

    public abstract Collection<FileAnnotation> parse(InputStream var1, String var2) throws InvocationTargetException;

    @Deprecated
    protected int createContextHashCode(String fileName, int line) throws IOException {
        return new ContextHashCode().compute(fileName, line, this.defaultEncoding);
    }

    protected int createContextHashCode(String fileName, int line, String warningType) {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(new ContextHashCode().compute(fileName, line, this.defaultEncoding));
        builder.append((Object)warningType);
        return builder.toHashCode();
    }
}

