/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.ThresholdValidator;
import hudson.plugins.analysis.util.model.AnnotationProvider;
import hudson.plugins.analysis.util.model.Priority;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractHealthDescriptor
implements HealthDescriptor {
    private static final long serialVersionUID = -3709673381162699834L;
    private final Priority priority;
    private final String healthy;
    private final String unHealthy;
    private Thresholds thresholds;
    @Deprecated
    private transient String threshold;
    @Deprecated
    private transient String newThreshold;
    @Deprecated
    private transient String failureThreshold;
    @Deprecated
    private transient String newFailureThreshold;
    @Deprecated
    private transient boolean isFailureThresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean isHealthyReportEnabled;

    public AbstractHealthDescriptor(HealthDescriptor healthDescriptor) {
        this.priority = healthDescriptor.getMinimumPriority();
        this.healthy = healthDescriptor.getHealthy();
        this.unHealthy = healthDescriptor.getUnHealthy();
        this.thresholds = healthDescriptor.getThresholds();
    }

    public AbstractHealthDescriptor() {
        this.thresholds = new Thresholds();
        this.healthy = "";
        this.unHealthy = "";
        this.priority = Priority.LOW;
    }

    @Override
    @Exported
    public Priority getMinimumPriority() {
        return this.priority;
    }

    @Override
    @Exported
    public String getHealthy() {
        return this.healthy;
    }

    @Override
    @Exported
    public String getUnHealthy() {
        return this.unHealthy;
    }

    @Override
    @Exported
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public boolean isEnabled() {
        return this.isHealthyReportEnabled() || this.isThresholdEnabled();
    }

    protected abstract Localizable createDescription(AnnotationProvider var1);

    public boolean isThresholdEnabled() {
        return this.thresholds.isValid();
    }

    public int getLowerBoundOfThresholds() {
        return this.thresholds.getLowerBound();
    }

    public boolean isHealthyReportEnabled() {
        if (ThresholdValidator.isValid(this.healthy) && ThresholdValidator.isValid(this.unHealthy)) {
            int healthyNumber = ThresholdValidator.convert(this.healthy);
            int unHealthyNumber = ThresholdValidator.convert(this.unHealthy);
            return unHealthyNumber > healthyNumber;
        }
        return false;
    }

    public int getHealthyAnnotations() {
        if (this.isHealthyReportEnabled()) {
            return ThresholdValidator.convert(this.healthy);
        }
        throw this.createException();
    }

    private IllegalArgumentException createException() {
        return new IllegalArgumentException("Healthy values are not valid: " + this.healthy + ", " + this.unHealthy);
    }

    public int getUnHealthyAnnotations() {
        if (this.isHealthyReportEnabled()) {
            return ThresholdValidator.convert(this.unHealthy);
        }
        throw this.createException();
    }

    protected Object readResolve() {
        if (this.thresholds == null) {
            this.thresholds = new Thresholds();
            if (this.threshold != null) {
                this.thresholds.unstableTotalAll = this.threshold;
                this.threshold = null;
            }
            if (this.newThreshold != null) {
                this.thresholds.unstableNewAll = this.newThreshold;
                this.newThreshold = null;
            }
            if (this.failureThreshold != null) {
                this.thresholds.failedTotalAll = this.failureThreshold;
                this.failureThreshold = null;
            }
            if (this.newFailureThreshold != null) {
                this.thresholds.failedNewAll = this.newFailureThreshold;
                this.newFailureThreshold = null;
            }
        }
        return this;
    }
}

