/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import com.google.common.collect.Lists;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Api;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.GlobalSettings;
import hudson.plugins.analysis.core.NullBuildHistory;
import hudson.plugins.analysis.core.NullHealthDescriptor;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.graph.AnnotationsByUserGraph;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.DefaultGraphConfigurationView;
import hudson.plugins.analysis.graph.DifferenceGraph;
import hudson.plugins.analysis.graph.EmptyGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.graph.GraphConfigurationView;
import hudson.plugins.analysis.graph.HealthGraph;
import hudson.plugins.analysis.graph.NewVersusFixedGraph;
import hudson.plugins.analysis.graph.NullGraph;
import hudson.plugins.analysis.graph.PriorityGraph;
import hudson.plugins.analysis.graph.TotalsGraph;
import hudson.plugins.analysis.graph.TrendDetails;
import hudson.plugins.analysis.graph.UserGraphConfigurationView;
import hudson.util.Graph;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import jenkins.model.Jenkins;
import org.jvnet.localizer.Localizable;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AbstractProjectAction<T extends ResultAction<?>>
implements Action {
    private static final Logger LOGGER = Logger.getLogger(AbstractProjectAction.class.getName());
    private final Job<?, ?> owner;
    private final Class<? extends T> resultActionType;
    private final String iconUrl;
    private final String pluginUrl;
    private final String resultUrl;
    private final Localizable name;
    private final Localizable trendName;

    public AbstractProjectAction(Job<?, ?> job, Class<? extends T> resultActionType, Localizable name, Localizable trendName, String pluginUrl, String iconUrl, String resultUrl) {
        this.owner = job;
        this.resultActionType = resultActionType;
        this.name = name;
        this.trendName = trendName;
        this.pluginUrl = pluginUrl;
        this.iconUrl = iconUrl;
        this.resultUrl = resultUrl;
    }

    @Deprecated
    public AbstractProjectAction(AbstractProject<?, ?> project, Class<? extends T> resultActionType, Localizable name, Localizable trendName, String pluginUrl, String iconUrl, String resultUrl) {
        this((Job<?, ?>)project, resultActionType, name, trendName, pluginUrl, iconUrl, resultUrl);
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    @Exported
    public String getDisplayName() {
        return this.asString(this.name);
    }

    private String asString(Localizable localizable) {
        if (localizable == null) {
            return null;
        }
        return localizable.toString();
    }

    public String getTrendName() {
        return this.asString(this.trendName);
    }

    public final Job<?, ?> getOwner() {
        return this.owner;
    }

    @Deprecated
    public final AbstractProject<?, ?> getProject() {
        return this.owner instanceof AbstractProject ? (AbstractProject)this.owner : null;
    }

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        if ("configureDefaults".equals(link)) {
            return this.createDefaultConfiguration();
        }
        if ("configure".equals(link)) {
            return this.createUserConfiguration(request);
        }
        return null;
    }

    public Object getTrendDetails() {
        return this.getTrendDetails(Stapler.getCurrentRequest(), Stapler.getCurrentResponse());
    }

    public Object getTrendDetails(StaplerRequest request, StaplerResponse response) {
        return new TrendDetails(this.getOwner(), this.getTrendGraph(request, response, "../../"), this.getTrendGraphId());
    }

    public Object getTrendGraph() {
        return this.getTrendGraph(Stapler.getCurrentRequest(), Stapler.getCurrentResponse());
    }

    public Graph getTrendGraph(StaplerRequest request, StaplerResponse response) {
        return this.getTrendGraph(request, response, "");
    }

    private Graph getTrendGraph(StaplerRequest request, StaplerResponse response, String urlPrefix) {
        GraphConfigurationView configuration = this.createUserConfiguration(request);
        if (configuration.hasMeaningfulGraph()) {
            configuration.setUrlPrefix(urlPrefix);
            return configuration.getGraphRenderer(this.getUrlName());
        }
        BuildResultGraph graphType = configuration.getGraphType();
        try {
            response.sendRedirect2(request.getContextPath() + graphType.getExampleImage());
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Can't create graph: " + graphType, exception);
        }
        return null;
    }

    public boolean isTrendVisible(StaplerRequest request) {
        GraphConfigurationView configuration = this.createUserConfiguration(request);
        return configuration.isVisible() && configuration.hasMeaningfulGraph();
    }

    public String getTrendGraphId() {
        GraphConfigurationView configuration = this.createUserConfiguration(Stapler.getCurrentRequest());
        return configuration.getGraphType().getId();
    }

    public boolean isTrendDeactivated(StaplerRequest request) {
        return this.createUserConfiguration(request).isDeactivated();
    }

    public boolean canShowEnableTrendLink(StaplerRequest request) {
        GraphConfigurationView configuration = this.createUserConfiguration(request);
        if (configuration.hasMeaningfulGraph()) {
            return !configuration.isDeactivated() && !configuration.isVisible();
        }
        return false;
    }

    protected GraphConfigurationView createUserConfiguration(StaplerRequest request) {
        return new UserGraphConfigurationView(this.createConfiguration(), this.getOwner(), this.getUrlName(), request.getCookies(), this.createBuildHistory());
    }

    protected GraphConfigurationView createDefaultConfiguration() {
        return new DefaultGraphConfigurationView(this.createConfiguration(), this.getOwner(), this.getUrlName(), this.createBuildHistory());
    }

    protected BuildHistory createBuildHistory() {
        Run<?, ?> lastFinishedRun = this.getLastFinishedRun();
        if (lastFinishedRun == null) {
            return new NullBuildHistory();
        }
        return new BuildHistory(lastFinishedRun, this.resultActionType, false, false);
    }

    private GraphConfiguration createConfiguration() {
        return this.createConfiguration(this.getAvailableGraphs());
    }

    protected List<BuildResultGraph> getAvailableGraphs() {
        ArrayList availableGraphs = Lists.newArrayList();
        availableGraphs.add(new NewVersusFixedGraph());
        availableGraphs.add(new PriorityGraph());
        availableGraphs.add(new TotalsGraph());
        if (this.hasValidResults()) {
            availableGraphs.add(new HealthGraph(this.getLastAction().getHealthDescriptor()));
        } else {
            availableGraphs.add(new HealthGraph(new NullHealthDescriptor()));
        }
        availableGraphs.add(new DifferenceGraph());
        availableGraphs.add(new EmptyGraph());
        availableGraphs.add(new NullGraph());
        if (!GlobalSettings.instance().getNoAuthors().booleanValue()) {
            availableGraphs.add(new AnnotationsByUserGraph());
        }
        return availableGraphs;
    }

    protected GraphConfiguration createConfiguration(List<BuildResultGraph> availableGraphs) {
        return new GraphConfiguration(availableGraphs);
    }

    public String getIconFileName() {
        ResultAction<?> lastAction = this.getLastAction();
        if (lastAction != null && ((BuildResult)lastAction.getResult()).hasAnnotations()) {
            return Jenkins.RESOURCE_PATH + this.iconUrl;
        }
        return null;
    }

    public final String getUrlName() {
        return this.pluginUrl;
    }

    public final boolean hasValidResults() {
        return this.getLastAction() != null;
    }

    @CheckForNull
    public ResultAction<?> getLastAction() {
        Run<?, ?> lastRun = this.getLastFinishedRun();
        if (lastRun == null) {
            return null;
        }
        return this.getResultAction(lastRun);
    }

    @CheckForNull
    protected T getResultAction(Run<?, ?> lastRun) {
        return (T)((ResultAction)lastRun.getAction(this.resultActionType));
    }

    @CheckForNull
    @Exported
    public Run<?, ?> getLastFinishedRun() {
        Run lastRun;
        if (this.owner == null) {
            return null;
        }
        for (lastRun = this.owner.getLastBuild(); lastRun != null && (lastRun.isBuilding() || this.getResultAction(lastRun) == null); lastRun = lastRun.getPreviousBuild()) {
        }
        return lastRun;
    }

    @Deprecated
    @CheckForNull
    @Exported
    public AbstractBuild<?, ?> getLastFinishedBuild() {
        Run<?, ?> lastFinishedRun = this.getLastFinishedRun();
        return lastFinishedRun instanceof AbstractBuild ? (AbstractBuild)lastFinishedRun : null;
    }

    public void doIndex(StaplerRequest request, StaplerResponse response) throws IOException {
        Run<?, ?> lastRun = this.getLastFinishedRun();
        if (lastRun != null) {
            response.sendRedirect2(String.format("../%d/%s", lastRun.getNumber(), this.resultUrl));
        }
    }

    @Deprecated
    public AbstractProjectAction(AbstractProject<?, ?> project, Class<? extends T> resultActionType, PluginDescriptor plugin) {
        this((Job<?, ?>)project, resultActionType, null, null, plugin.getPluginName(), plugin.getIconUrl(), plugin.getPluginResultUrlName());
    }
}

