/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.HealthReport;
import hudson.model.HealthReportingAction;
import hudson.model.Job;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthReportBuilder;
import hudson.plugins.analysis.core.NullHealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.plugins.analysis.util.model.AnnotationProvider;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerProxy;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
@BridgeMethodsAdded
public abstract class AbstractResultAction<T extends BuildResult>
implements StaplerProxy,
HealthReportingAction,
ToolTipProvider,
ResultAction<T>,
SimpleBuildStep.LastBuildAction {
    private final Run<?, ?> owner;
    private final AbstractHealthDescriptor healthDescriptor;
    private T result;
    @Deprecated
    @SuppressFBWarnings(value={"UuF"})
    private transient HealthReportBuilder healthReportBuilder;

    public AbstractResultAction(Run<?, ?> owner, AbstractHealthDescriptor healthDescriptor, T result) {
        this.owner = owner;
        this.result = result;
        this.healthDescriptor = healthDescriptor;
    }

    protected Set<Action> asSet(Action action) {
        return Collections.singleton(action);
    }

    @Override
    public AbstractHealthDescriptor getHealthDescriptor() {
        if (this.healthDescriptor == null) {
            return NullHealthDescriptor.NULL_HEALTH_DESCRIPTOR;
        }
        return this.healthDescriptor;
    }

    protected abstract PluginDescriptor getDescriptor();

    @Exported
    public String getName() {
        return this.getDescriptor().getPluginName();
    }

    protected Job<?, ?> getJob() {
        return this.getBuild().getParent();
    }

    public String getUrlName() {
        return this.getDescriptor().getPluginResultUrlName();
    }

    @Exported
    public final HealthReport getBuildHealth() {
        return new HealthReportBuilder(this.getHealthDescriptor()).computeHealth((AnnotationProvider)this.getResult());
    }

    @Override
    public ToolTipProvider getToolTipProvider() {
        return this;
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public final Run<?, ?> getOwner() {
        return this.owner;
    }

    @Override
    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public final Run<?, ?> getBuild() {
        return this.owner;
    }

    public Collection<? extends Action> getProjectActions() {
        return Collections.emptyList();
    }

    @Deprecated
    private Object getAbstractBuild(Run owner, Class targetClass) {
        return owner instanceof AbstractBuild ? (AbstractBuild)owner : null;
    }

    public final Object getTarget() {
        return this.getResult();
    }

    @Override
    @Exported
    public final T getResult() {
        return this.result;
    }

    @Override
    public final void setResult(T result) {
        this.result = result;
    }

    public String getIconFileName() {
        T currentResult = this.getResult();
        if (currentResult != null && ((BuildResult)currentResult).getNumberOfAnnotations() > 0) {
            return this.getSmallImage();
        }
        return null;
    }

    public boolean hasLargeImage() {
        return StringUtils.isNotBlank((String)this.getLargeImageName());
    }

    public String getLargeImageName() {
        return this.getDescriptor().getSummaryIconUrl();
    }

    public String getSmallImageName() {
        return this.getSmallImage();
    }

    protected String getSmallImage() {
        return this.createStaticIconUrl(this.getDescriptor().getIconUrl());
    }

    private String createStaticIconUrl(String iconUrl) {
        return Jenkins.RESOURCE_PATH + "/" + iconUrl;
    }

    protected ParserResult createResult() {
        return new ParserResult();
    }

    @Override
    public String getTooltip(int numberOfItems) {
        if (numberOfItems == 1) {
            return this.getSingleItemTooltip();
        }
        return this.getMultipleItemsTooltip(numberOfItems);
    }

    protected String getMultipleItemsTooltip(int numberOfItems) {
        return Messages.ResultAction_MultipleWarnings(numberOfItems);
    }

    protected String getSingleItemTooltip() {
        return Messages.ResultAction_OneWarning();
    }

    @Override
    @Exported
    public boolean isSuccessful() {
        return ((BuildResult)this.getResult()).isSuccessful();
    }

    @Deprecated
    protected ParserResult createAggregatedResult(Map<MavenModule, List<MavenBuild>> moduleBuilds) {
        return new ParserResult();
    }

    @Deprecated
    protected void updateBuildHealth(MavenBuild build, BuildResult buildResult) {
    }

    @Deprecated
    protected void addModule(ParserResult aggregatedResult, List<MavenBuild> builds) {
    }

    @Deprecated
    public AbstractResultAction(AbstractBuild<?, ?> owner, AbstractHealthDescriptor healthDescriptor) {
        this.owner = owner;
        this.healthDescriptor = healthDescriptor;
    }

    @Deprecated
    public AbstractResultAction(AbstractBuild<?, ?> owner, AbstractHealthDescriptor healthDescriptor, T result) {
        this.owner = owner;
        this.result = result;
        this.healthDescriptor = healthDescriptor;
    }
}

