/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.Launcher;
import hudson.matrix.MatrixAggregator;
import hudson.matrix.MatrixBuild;
import hudson.matrix.MatrixRun;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import java.io.IOException;
import javax.annotation.Nonnull;

public abstract class AnnotationsAggregator
extends MatrixAggregator {
    private final ParserResult totals = new ParserResult();
    private final HealthDescriptor healthDescriptor;
    private final String defaultEncoding;
    private final boolean useStableBuildAsReference;
    private final boolean usePreviousBuildAsReference;

    public AnnotationsAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, HealthDescriptor healthDescriptor, String defaultEncoding, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        super(build, launcher, listener);
        this.healthDescriptor = healthDescriptor;
        this.defaultEncoding = defaultEncoding;
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
        this.useStableBuildAsReference = useStableBuildAsReference;
    }

    public boolean endRun(MatrixRun run) throws InterruptedException, IOException {
        if (this.totals.hasNoAnnotations() && this.hasResult(run)) {
            BuildResult result = this.getResult(run);
            this.totals.addAnnotations(result.getAnnotations());
            this.totals.addModules(result.getModules());
        }
        return true;
    }

    public boolean endBuild() throws InterruptedException, IOException {
        this.build.addAction(this.createAction(this.healthDescriptor, this.defaultEncoding, this.totals));
        return true;
    }

    protected boolean hasResult(MatrixRun run) {
        return false;
    }

    public boolean useOnlyStableBuildsAsReference() {
        return this.useStableBuildAsReference;
    }

    public boolean usePreviousBuildAsReference() {
        return this.usePreviousBuildAsReference;
    }

    @Nonnull
    protected abstract BuildResult getResult(MatrixRun var1);

    protected abstract Action createAction(HealthDescriptor var1, String var2, ParserResult var3);

    @Deprecated
    public AnnotationsAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, HealthDescriptor healthDescriptor, String defaultEncoding, boolean useStableBuildAsReference) {
        this(build, launcher, listener, healthDescriptor, defaultEncoding, false, useStableBuildAsReference);
    }

    @Deprecated
    public AnnotationsAggregator(MatrixBuild build, Launcher launcher, BuildListener listener, HealthDescriptor healthDescriptor, String defaultEncoding) {
        this(build, launcher, listener, healthDescriptor, defaultEncoding, false);
    }
}

