/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.model.AbstractBuild;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.IssueDifference;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.DefaultAnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

@BridgeMethodsAdded
public class BuildHistory {
    private final Run<?, ?> baseline;
    private final Class<? extends ResultAction<? extends BuildResult>> type;
    private final boolean useStableBuildAsReference;
    private final boolean usePreviousBuildAsReference;

    public BuildHistory(Run<?, ?> baseline, Class<? extends ResultAction<? extends BuildResult>> type, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        this.baseline = baseline;
        this.type = type;
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
        this.useStableBuildAsReference = useStableBuildAsReference;
    }

    public boolean useOnlyStableBuildsAsReference() {
        return this.useStableBuildAsReference;
    }

    public boolean usePreviousBuildAsStable() {
        return this.usePreviousBuildAsReference;
    }

    public Calendar getTimestamp() {
        return this.baseline.getTimestamp();
    }

    private boolean hasReferenceResult() {
        return this.getReferenceAction() != null;
    }

    public AnnotationContainer getReferenceAnnotations() {
        ResultAction<? extends BuildResult> action = this.getReferenceAction();
        if (action != null) {
            return action.getResult().getContainer();
        }
        return new DefaultAnnotationContainer();
    }

    private ResultAction<? extends BuildResult> getReferenceAction() {
        if (this.usePreviousBuildAsReference) {
            return this.getPreviousAction();
        }
        ResultAction<? extends BuildResult> action = this.getAction(true, this.useStableBuildAsReference);
        if (action == null) {
            return this.getPreviousAction();
        }
        return action;
    }

    private ResultAction<? extends BuildResult> getAction(boolean isStatusRelevant) {
        return this.getAction(isStatusRelevant, false);
    }

    private ResultAction<? extends BuildResult> getAction(boolean isStatusRelevant, boolean mustBeStable) {
        for (Run build = this.baseline.getPreviousBuild(); build != null; build = build.getPreviousBuild()) {
            ResultAction<? extends BuildResult> action = this.getResultAction(build);
            if (!this.hasValidResult(build, mustBeStable, action) || !this.isSuccessfulAction(action, isStatusRelevant)) continue;
            return action;
        }
        return null;
    }

    private boolean isSuccessfulAction(ResultAction<? extends BuildResult> action, boolean isStatusRelevant) {
        return action != null && (action.isSuccessful() || !isStatusRelevant);
    }

    @CheckForNull
    public ResultAction<? extends BuildResult> getResultAction(@Nonnull Run<?, ?> build) {
        return (ResultAction)build.getAction(this.type);
    }

    @CheckForNull
    private ResultAction<? extends BuildResult> getPreviousAction() {
        return this.getAction(false);
    }

    @CheckForNull
    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getReferenceAbstractBuild")
    public Run<?, ?> getReferenceBuild() {
        Run<?, ?> build;
        ResultAction<? extends BuildResult> action = this.getReferenceAction();
        if (action != null && this.hasValidResult(build = action.getBuild())) {
            return build;
        }
        return null;
    }

    @Deprecated
    private Object getReferenceAbstractBuild(Run run, Class targetClass) {
        return run instanceof AbstractBuild ? (AbstractBuild)run : null;
    }

    private boolean hasValidResult(Run<?, ?> build) {
        return this.hasValidResult(build, false, null);
    }

    private boolean hasValidResult(Run<?, ?> build, boolean mustBeStable, @CheckForNull ResultAction<? extends BuildResult> action) {
        Result result = build.getResult();
        if (result == null) {
            return false;
        }
        if (mustBeStable) {
            return result == Result.SUCCESS;
        }
        return result.isBetterThan(Result.FAILURE) || this.isPluginCauseForFailure(action);
    }

    private boolean isPluginCauseForFailure(@CheckForNull ResultAction<? extends BuildResult> action) {
        if (action == null) {
            return false;
        }
        return action.getResult().getPluginResult().isWorseOrEqualTo(Result.FAILURE);
    }

    public boolean hasReferenceBuild() {
        return this.getReferenceBuild() != null;
    }

    public boolean hasPreviousResult() {
        return this.getPreviousAction() != null;
    }

    public boolean isEmpty() {
        return !this.hasPreviousResult();
    }

    public ResultAction<? extends BuildResult> getBaseline() {
        return this.getResultAction(this.baseline);
    }

    public BuildResult getPreviousResult() {
        ResultAction<? extends BuildResult> action = this.getPreviousAction();
        if (action != null) {
            return action.getResult();
        }
        throw new NoSuchElementException("No previous result available");
    }

    public Collection<FileAnnotation> getNewWarnings(Set<FileAnnotation> annotations) {
        if (this.hasReferenceResult()) {
            return new IssueDifference(annotations, this.getReferenceAnnotations().getAnnotations()).getNewIssues();
        }
        return annotations;
    }

    public Collection<FileAnnotation> getFixedWarnings(Set<FileAnnotation> annotations) {
        if (this.hasReferenceResult()) {
            return new IssueDifference(annotations, this.getReferenceAnnotations().getAnnotations()).getFixedIssues();
        }
        return Collections.emptyList();
    }

    public AbstractHealthDescriptor getHealthDescriptor() {
        return this.getBaseline().getHealthDescriptor();
    }

    @Deprecated
    public BuildHistory(AbstractBuild<?, ?> baseline, Class<? extends ResultAction<? extends BuildResult>> type, boolean useStableBuildAsReference) {
        this(baseline, type, false, useStableBuildAsReference);
    }

    @Deprecated
    public BuildHistory(AbstractBuild<?, ?> baseline, Class<? extends ResultAction<? extends BuildResult>> type) {
        this(baseline, type, false);
    }

    @Deprecated
    public BuildHistory(AbstractBuild<?, ?> baseline, Class<? extends ResultAction<? extends BuildResult>> type, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference) {
        this((Run<?, ?>)baseline, type, usePreviousBuildAsReference, useStableBuildAsReference);
    }

    @CheckForNull
    @Deprecated
    public ResultAction<? extends BuildResult> getResultAction(AbstractBuild<?, ?> build) {
        return this.getResultAction((Run<?, ?>)build);
    }
}

