/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import com.google.common.collect.Sets;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.XmlFile;
import hudson.model.AbstractBuild;
import hudson.model.Api;
import hudson.model.ModelObject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.core.BuildResultEvaluator;
import hudson.plugins.analysis.core.GlobalSettings;
import hudson.plugins.analysis.core.IssueDifference;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.HtmlPrinter;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.AnnotationContainer;
import hudson.plugins.analysis.util.model.AnnotationProvider;
import hudson.plugins.analysis.util.model.AnnotationStream;
import hudson.plugins.analysis.util.model.AnnotationsLabelProvider;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.JavaProject;
import hudson.plugins.analysis.util.model.MavenModule;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.analysis.views.DetailFactory;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.apache.commons.lang.ObjectUtils;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
@BridgeMethodsAdded
public abstract class BuildResult
implements ModelObject,
Serializable,
AnnotationProvider {
    private static final long serialVersionUID = 1110545450292087475L;
    private static final Logger LOGGER = Logger.getLogger(BuildResult.class.getName());
    private static final String UNSTABLE = "yellow.png";
    private static final String FAILED = "red.png";
    private static final String SUCCESS = "blue.png";
    private transient Object projectLock = new Object();
    private Run<?, ?> owner;
    private Set<String> modules;
    private int numberOfModules;
    private String defaultEncoding;
    @SuppressFBWarnings(value={"Se"})
    private transient WeakReference<JavaProject> project;
    @SuppressFBWarnings(value={"Se"})
    private transient WeakReference<Collection<FileAnnotation>> newWarningsReference;
    @SuppressFBWarnings(value={"Se"})
    private transient WeakReference<Collection<FileAnnotation>> fixedWarningsReference;
    private transient BuildHistory history;
    private int numberOfWarnings;
    private int numberOfNewWarnings;
    private int numberOfFixedWarnings;
    private int delta;
    private int lowDelta;
    private int normalDelta;
    private int highDelta;
    private int lowWarnings;
    private int normalWarnings;
    private int highWarnings;
    private int zeroWarningsSinceBuild;
    private long zeroWarningsSinceDate;
    private long zeroWarningsHighScore;
    private boolean isZeroWarningsHighscore;
    private long highScoreGap;
    @SuppressFBWarnings(value={"Se"})
    private List<String> errors;
    private Result pluginResult = Result.SUCCESS;
    private int successfulSinceBuild;
    private long successfulSinceDate;
    private long successfulHighscore;
    private boolean isSuccessfulHighscore;
    private long successfulHighScoreGap;
    private boolean isSuccessfulStateTouched;
    private transient boolean useDeltaValues;
    private transient Thresholds thresholds = new Thresholds();
    private int referenceBuild;
    private String reason;
    @Deprecated
    private transient Map<String, MavenModule> emptyModules;
    @Deprecated
    protected transient String low;
    @Deprecated
    protected transient String normal;
    @Deprecated
    protected transient String high;

    public static long getDays(long ms) {
        return Math.max(1L, ms / 86400000L);
    }

    protected BuildResult(Run<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding) {
        this.initialize(history, build, defaultEncoding, result);
    }

    public boolean useAuthors() {
        return GlobalSettings.instance().getNoAuthors() == false;
    }

    protected BuildHistory createHistory(@Nonnull Run<?, ?> build) {
        return new BuildHistory(build, this.getResultActionType(), false, false);
    }

    public boolean useOnlyStableBuildsAsReference() {
        return this.history.useOnlyStableBuildsAsReference();
    }

    public boolean usePreviousBuildAsStable() {
        return this.history.usePreviousBuildAsStable();
    }

    private void initialize(BuildHistory history, Run<?, ?> build, String defaultEncoding, ParserResult result) {
        this.history = history;
        this.owner = build;
        this.defaultEncoding = defaultEncoding;
        this.modules = new HashSet<String>(result.getModules());
        this.numberOfModules = this.modules.size();
        this.errors = new ArrayList<String>(result.getErrorMessages());
        this.numberOfWarnings = result.getNumberOfAnnotations();
        AnnotationContainer referenceResult = history.getReferenceAnnotations();
        this.delta = result.getNumberOfAnnotations() - referenceResult.getNumberOfAnnotations();
        this.lowDelta = this.computeDelta(result, referenceResult, Priority.LOW);
        this.normalDelta = this.computeDelta(result, referenceResult, Priority.NORMAL);
        this.highDelta = this.computeDelta(result, referenceResult, Priority.HIGH);
        Set<FileAnnotation> allWarnings = result.getAnnotations();
        IssueDifference difference = new IssueDifference(allWarnings, referenceResult.getAnnotations());
        Set<FileAnnotation> newWarnings = difference.getNewIssues();
        this.numberOfNewWarnings = newWarnings.size();
        this.newWarningsReference = new WeakReference<Set<FileAnnotation>>(newWarnings);
        Set<FileAnnotation> fixedWarnings = difference.getFixedIssues();
        this.numberOfFixedWarnings = fixedWarnings.size();
        this.fixedWarningsReference = new WeakReference<Set<FileAnnotation>>(fixedWarnings);
        this.highWarnings = result.getNumberOfAnnotations(Priority.HIGH);
        this.normalWarnings = result.getNumberOfAnnotations(Priority.NORMAL);
        this.lowWarnings = result.getNumberOfAnnotations(Priority.LOW);
        JavaProject container = new JavaProject();
        container.addAnnotations(result.getAnnotations());
        for (FileAnnotation newWarning : newWarnings) {
            newWarning.setBuild(build.getNumber());
        }
        this.project = new WeakReference<JavaProject>(container);
        this.computeZeroWarningsHighScore(build, result);
        this.defineReferenceBuild(history);
    }

    public BuildHistory getHistory() {
        return this.history;
    }

    @SuppressFBWarnings(value={"NP"})
    private void defineReferenceBuild(BuildHistory buildHistory) {
        this.referenceBuild = buildHistory.hasReferenceBuild() ? buildHistory.getReferenceBuild().getNumber() : -1;
    }

    private boolean hasReferenceBuild() {
        return this.referenceBuild > 0 && this.getReferenceBuild() != null;
    }

    @Exported
    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getReferenceAbstractBuild")
    public Run<?, ?> getReferenceBuild() {
        return this.owner.getParent().getBuildByNumber(this.referenceBuild);
    }

    @Deprecated
    private final Object getReferenceAbstractBuild(Run owner, Class targetClass) {
        return owner instanceof AbstractBuild ? ((AbstractBuild)owner).getProject().getBuildByNumber(this.referenceBuild) : null;
    }

    private int computeDelta(ParserResult result, AnnotationContainer referenceResult, Priority priority) {
        return result.getNumberOfAnnotations(priority) - referenceResult.getNumberOfAnnotations(priority);
    }

    private void computeZeroWarningsHighScore(Run<?, ?> build, ParserResult currentResult) {
        if (this.history.hasPreviousResult()) {
            BuildResult previous = this.history.getPreviousResult();
            if (currentResult.hasNoAnnotations()) {
                if (previous.hasNoAnnotations()) {
                    this.zeroWarningsSinceBuild = previous.getZeroWarningsSinceBuild();
                    this.zeroWarningsSinceDate = previous.getZeroWarningsSinceDate();
                } else {
                    this.zeroWarningsSinceBuild = build.getNumber();
                    this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
                }
                this.zeroWarningsHighScore = Math.max(previous.getZeroWarningsHighScore(), build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
                if (previous.getZeroWarningsHighScore() == 0L) {
                    this.isZeroWarningsHighscore = true;
                } else {
                    boolean bl = this.isZeroWarningsHighscore = this.zeroWarningsHighScore != previous.getZeroWarningsHighScore();
                }
                if (!this.isZeroWarningsHighscore) {
                    this.highScoreGap = previous.getZeroWarningsHighScore() - (build.getTimestamp().getTimeInMillis() - this.zeroWarningsSinceDate);
                }
            } else {
                this.zeroWarningsHighScore = previous.getZeroWarningsHighScore();
            }
        } else if (currentResult.hasNoAnnotations()) {
            this.zeroWarningsSinceBuild = build.getNumber();
            this.zeroWarningsSinceDate = build.getTimestamp().getTimeInMillis();
            this.isZeroWarningsHighscore = true;
            this.zeroWarningsHighScore = 0L;
        }
    }

    public boolean hasError() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    protected Object readResolve() {
        this.projectLock = new Object();
        if (this.pluginResult == null) {
            this.pluginResult = Result.SUCCESS;
            this.resetSuccessfulState();
        }
        if (this.projectLock == null) {
            this.projectLock = new Object();
        }
        if (this.history == null) {
            this.history = this.createHistory(this.owner);
        }
        if (this.modules == null) {
            this.modules = new HashSet<String>();
        }
        if (this.errors == null) {
            this.errors = new ArrayList<String>();
        }
        try {
            if (this.low != null) {
                this.lowWarnings = Integer.valueOf(this.low);
            }
            if (this.normal != null) {
                this.normalWarnings = Integer.valueOf(this.normal);
            }
            if (this.high != null) {
                this.highWarnings = Integer.valueOf(this.high);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return this;
    }

    @Exported
    public Collection<String> getModules() {
        return this.modules;
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public Thresholds getThresholds() {
        return (Thresholds)ObjectUtils.defaultIfNull((Object)this.thresholds, (Object)new Thresholds());
    }

    public boolean canUseDeltaValues() {
        return this.useDeltaValues;
    }

    public final XmlFile getDataFile() {
        return new XmlFile(this.getXStream(), new File(this.getOwner().getRootDir(), this.getSerializationFileName()));
    }

    private XmlFile getFixedDataFile() {
        return new XmlFile(this.getXStream(), new File(this.getOwner().getRootDir(), this.getSerializationFileName().replace(".xml", "-fixed.xml")));
    }

    private XStream getXStream() {
        AnnotationStream xstream = new AnnotationStream();
        this.configure((XStream)xstream);
        return xstream;
    }

    protected void configure(XStream xstream) {
    }

    protected abstract String getSerializationFileName();

    public boolean isCurrent() {
        return this.getOwner().getParent().getLastBuild().number == this.getOwner().number;
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public Run<?, ?> getOwner() {
        return this.owner;
    }

    @Deprecated
    private Object getAbstractBuild(Run owner, Class targetClass) {
        return owner instanceof AbstractBuild ? (AbstractBuild)owner : null;
    }

    @Override
    public boolean hasAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public boolean hasAnnotations() {
        return this.numberOfWarnings != 0;
    }

    @Override
    public boolean hasNoAnnotations() {
        return this.numberOfWarnings == 0;
    }

    @Override
    public boolean hasNoAnnotations(Priority priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    public boolean hasNoAnnotations(String priority) {
        return this.getContainer().hasAnnotations(priority);
    }

    @Override
    @Exported(name="warnings")
    public Set<FileAnnotation> getAnnotations() {
        return this.getContainer().getAnnotations();
    }

    @Override
    public FileAnnotation getAnnotation(long key) {
        return this.getContainer().getAnnotation(key);
    }

    @Override
    public FileAnnotation getAnnotation(String key) {
        return this.getContainer().getAnnotation(key);
    }

    protected void setHighWarnings(int highWarnings) {
        this.highWarnings = highWarnings;
    }

    protected void setNormalWarnings(int normalWarnings) {
        this.normalWarnings = normalWarnings;
    }

    protected void setLowWarnings(int lowWarnings) {
        this.lowWarnings = lowWarnings;
    }

    protected void setWarnings(int warnings) {
        this.numberOfWarnings = warnings;
    }

    @Override
    public Set<FileAnnotation> getAnnotations(Priority priority) {
        return this.getContainer().getAnnotations(priority);
    }

    protected void serializeAnnotations(Collection<FileAnnotation> annotations) {
        try {
            this.getDataFile().write((Object)annotations.toArray(new FileAnnotation[annotations.size()]));
            HashSet<FileAnnotation> allAnnotations = new HashSet<FileAnnotation>();
            allAnnotations.addAll(annotations);
            Collection<FileAnnotation> fixedWarnings = this.history.getFixedWarnings(allAnnotations);
            this.getFixedDataFile().write((Object)fixedWarnings.toArray(new FileAnnotation[fixedWarnings.size()]));
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Failed to serialize the annotations of the build.", exception);
        }
    }

    @Exported
    public int getZeroWarningsSinceBuild() {
        return this.zeroWarningsSinceBuild;
    }

    @Exported
    public long getZeroWarningsSinceDate() {
        return this.zeroWarningsSinceDate;
    }

    @Exported
    public long getZeroWarningsHighScore() {
        return this.zeroWarningsHighScore;
    }

    @Exported
    public boolean isNewZeroWarningsHighScore() {
        return this.isZeroWarningsHighscore;
    }

    public long getHighScoreGap() {
        return this.highScoreGap;
    }

    @Exported
    public int getSuccessfulSinceBuild() {
        return this.successfulSinceBuild;
    }

    @Exported
    public long getSuccessfulSinceDate() {
        return this.successfulSinceDate;
    }

    @Exported
    public long getSuccessfulHighScore() {
        return this.successfulHighscore;
    }

    @Exported
    public boolean isNewSuccessfulHighScore() {
        return this.isSuccessfulHighscore;
    }

    public long getSuccessfulHighScoreGap() {
        return this.successfulHighScoreGap;
    }

    @Exported
    public int getNumberOfWarnings() {
        return this.numberOfWarnings;
    }

    @Override
    public int getNumberOfAnnotations() {
        return this.getNumberOfWarnings();
    }

    @Override
    public int getNumberOfAnnotations(Priority priority) {
        if (priority == Priority.HIGH) {
            return this.highWarnings;
        }
        if (priority == Priority.NORMAL) {
            return this.normalWarnings;
        }
        return this.lowWarnings;
    }

    @Exported
    public int getNumberOfFixedWarnings() {
        return this.numberOfFixedWarnings;
    }

    @Exported
    public int getNumberOfNewWarnings() {
        return this.numberOfNewWarnings;
    }

    public int getDelta() {
        return this.delta;
    }

    public int getHighDelta() {
        return this.highDelta;
    }

    public int getNormalDelta() {
        return this.normalDelta;
    }

    public int getLowDelta() {
        return this.lowDelta;
    }

    @Exported
    public int getWarningsDelta() {
        return this.delta;
    }

    @Exported
    public int getNumberOfHighPriorityWarnings() {
        return this.highWarnings;
    }

    @Exported
    public int getNumberOfNormalPriorityWarnings() {
        return this.normalWarnings;
    }

    @Exported
    public int getNumberOfLowPriorityWarnings() {
        return this.lowWarnings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JavaProject getProject() {
        Object object = this.projectLock;
        synchronized (object) {
            if (this.project == null) {
                return this.loadResult();
            }
            JavaProject result = (JavaProject)this.project.get();
            if (result == null) {
                return this.loadResult();
            }
            return result;
        }
    }

    private JavaProject loadResult() {
        JavaProject result;
        try {
            JavaProject newProject = new JavaProject();
            FileAnnotation[] annotations = (FileAnnotation[])this.getDataFile().read();
            newProject.addAnnotations(annotations);
            this.attachLabelProvider(newProject);
            LOGGER.log(Level.FINE, "Loaded data file " + this.getDataFile() + " for build " + this.getOwner().getNumber());
            result = newProject;
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getDataFile(), exception);
            result = new JavaProject();
        }
        this.project = new WeakReference<JavaProject>(result);
        return result;
    }

    protected void attachLabelProvider(AnnotationContainer container) {
        container.setLabelProvider(new AnnotationsLabelProvider(container.getPackageCategoryTitle()));
    }

    @Exported
    public Collection<FileAnnotation> getNewWarnings() {
        if (this.newWarningsReference == null) {
            return this.loadNewWarnings();
        }
        Collection result = (Collection)this.newWarningsReference.get();
        if (result == null) {
            return this.loadNewWarnings();
        }
        return result;
    }

    private Collection<FileAnnotation> loadNewWarnings() {
        HashSet<FileAnnotation> newWarnings = new HashSet<FileAnnotation>();
        for (FileAnnotation warning : this.getProject().getAnnotations()) {
            if (warning.getBuild() != this.getOwner().getNumber()) continue;
            newWarnings.add(warning);
        }
        this.newWarningsReference = new WeakReference(newWarnings);
        return newWarnings;
    }

    public Collection<FileAnnotation> getFixedWarnings() {
        if (this.getFixedDataFile().exists()) {
            return this.getFixedWarningsAfterRelease72();
        }
        return this.getFixedWarningsBeforeRelease72();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<FileAnnotation> getFixedWarningsAfterRelease72() {
        Object object = this.projectLock;
        synchronized (object) {
            if (this.fixedWarningsReference == null) {
                return this.loadFixedWarningsAfterRelease72();
            }
            Collection result = (Collection)this.fixedWarningsReference.get();
            if (result == null) {
                return this.loadFixedWarningsAfterRelease72();
            }
            return result;
        }
    }

    private Collection<FileAnnotation> loadFixedWarningsAfterRelease72() {
        HashSet<FileAnnotation> fixedWarnings;
        try {
            Object[] annotations = (FileAnnotation[])this.getFixedDataFile().read();
            fixedWarnings = Sets.newHashSet((Object[])annotations);
            LOGGER.log(Level.FINE, "Loaded data file " + this.getFixedDataFile() + " for build " + this.getOwner().getNumber());
        }
        catch (IOException exception) {
            LOGGER.log(Level.WARNING, "Failed to load " + this.getFixedDataFile(), exception);
            fixedWarnings = new HashSet<FileAnnotation>();
        }
        this.fixedWarningsReference = new WeakReference(fixedWarnings);
        return fixedWarnings;
    }

    private Collection<FileAnnotation> getFixedWarningsBeforeRelease72() {
        if (this.fixedWarningsReference == null) {
            return this.loadFixedWarningsBeforeRelease72();
        }
        Collection result = (Collection)this.fixedWarningsReference.get();
        if (result == null) {
            return this.loadFixedWarningsBeforeRelease72();
        }
        return result;
    }

    private Collection<FileAnnotation> loadFixedWarningsBeforeRelease72() {
        Collection<FileAnnotation> difference = this.history.getFixedWarnings(this.getProject().getAnnotations());
        this.fixedWarningsReference = new WeakReference<Collection<FileAnnotation>>(difference);
        return difference;
    }

    protected abstract Class<? extends ResultAction<? extends BuildResult>> getResultActionType();

    public Object getDynamic(String link, StaplerRequest request, StaplerResponse response) {
        try {
            return DetailFactory.create(this.getResultActionType()).createTrendDetails(link, this.getOwner(), this.getContainer(), this.getFixedWarnings(), this.getNewWarnings(), this.getErrors(), this.getDefaultEncoding(), this.getDisplayName());
        }
        catch (NoSuchElementException exception) {
            try {
                response.sendRedirect2("../");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return this;
        }
    }

    public Priority[] getPriorities() {
        return Priority.values();
    }

    @Override
    public Set<FileAnnotation> getAnnotations(String priority) {
        return this.getContainer().getAnnotations(priority);
    }

    @Override
    public int getNumberOfAnnotations(String priority) {
        return this.getNumberOfAnnotations(Priority.fromString(priority));
    }

    public AnnotationContainer getContainer() {
        return this.getProject();
    }

    public Api getApi() {
        return new Api((Object)this);
    }

    public boolean isSuccessful() {
        return this.pluginResult == Result.SUCCESS;
    }

    public void evaluateStatus(Thresholds thresholds, boolean useDeltaValues, PluginLogger logger, String url) {
        this.evaluateStatus(thresholds, useDeltaValues, true, logger, url);
    }

    public void evaluateStatus(Thresholds thresholds, boolean useDeltaValues, boolean canComputeNew, PluginLogger logger, String url) {
        Result buildResult;
        this.thresholds = thresholds;
        this.useDeltaValues = useDeltaValues;
        BuildResultEvaluator resultEvaluator = new BuildResultEvaluator(url);
        StringBuilder messages = new StringBuilder();
        if (this.history.isEmpty() || !canComputeNew) {
            logger.log("Ignore new warnings since this is the first valid build");
            buildResult = resultEvaluator.evaluateBuildResult(messages, thresholds, this.getAnnotations());
        } else {
            buildResult = useDeltaValues ? resultEvaluator.evaluateBuildResult(messages, thresholds, this.getAnnotations(), this.getDelta(), this.getHighDelta(), this.getNormalDelta(), this.getLowDelta()) : resultEvaluator.evaluateBuildResult(messages, thresholds, this.getAnnotations(), this.getNewWarnings());
        }
        this.reason = messages.toString();
        this.saveResult(buildResult);
        logger.log(String.format("%s %s - %s", Messages.ResultAction_Status(), buildResult.color.getDescription(), this.getReason()));
    }

    @Deprecated
    public void setResult(Result result) {
        this.saveResult(result);
    }

    private void saveResult(Result result) {
        this.isSuccessfulStateTouched = true;
        this.pluginResult = result;
        this.owner.setResult(result);
        if (this.history.hasPreviousResult()) {
            BuildResult previous = this.history.getPreviousResult();
            if (this.isSuccessful()) {
                if (previous.isSuccessful() && previous.isSuccessfulTouched()) {
                    this.successfulSinceBuild = previous.getSuccessfulSinceBuild();
                    this.successfulSinceDate = previous.getSuccessfulSinceDate();
                } else {
                    this.successfulSinceBuild = this.owner.getNumber();
                    this.successfulSinceDate = this.owner.getTimestamp().getTimeInMillis();
                }
                this.successfulHighscore = Math.max(previous.getSuccessfulHighScore(), this.owner.getTimestamp().getTimeInMillis() - this.successfulSinceDate);
                if (previous.getSuccessfulHighScore() == 0L) {
                    this.isSuccessfulHighscore = true;
                } else {
                    boolean bl = this.isSuccessfulHighscore = this.successfulHighscore != previous.getSuccessfulHighScore();
                }
                if (!this.isSuccessfulHighscore) {
                    this.successfulHighScoreGap = previous.getSuccessfulHighScore() - (this.owner.getTimestamp().getTimeInMillis() - this.successfulSinceDate);
                }
            } else {
                this.successfulHighscore = previous.getSuccessfulHighScore();
            }
        } else if (this.isSuccessful()) {
            this.resetSuccessfulState();
        }
    }

    @Exported
    public Result getPluginResult() {
        return this.pluginResult;
    }

    public boolean isSuccessfulTouched() {
        return this.isSuccessfulStateTouched;
    }

    public boolean hasPreviousResult() {
        return this.history.hasPreviousResult();
    }

    public BuildResult getPreviousResult() {
        return this.history.getPreviousResult();
    }

    private void resetSuccessfulState() {
        this.successfulSinceBuild = this.owner.getNumber();
        this.successfulSinceDate = this.owner.getTimestamp().getTimeInMillis();
        this.isSuccessfulHighscore = true;
        this.successfulHighscore = 0L;
    }

    public String getReason() {
        return this.reason;
    }

    protected static String createDefaultSummary(String url, int warnings, int modules) {
        HtmlPrinter summary = new HtmlPrinter();
        String message = BuildResult.createWarningsMessage(warnings);
        if (warnings > 0) {
            summary.append(summary.link(url, message));
        } else {
            summary.append(message);
        }
        if (modules > 0) {
            summary.append(" ");
            summary.append(BuildResult.createAnalysesMessage(modules));
        } else {
            summary.append(".");
        }
        return summary.toString();
    }

    private static String createAnalysesMessage(int modules) {
        if (modules == 1) {
            return Messages.ResultAction_OneFile();
        }
        return Messages.ResultAction_MultipleFiles(modules);
    }

    private static String createWarningsMessage(int warnings) {
        if (warnings == 1) {
            return Messages.ResultAction_OneWarning();
        }
        return Messages.ResultAction_MultipleWarnings(warnings);
    }

    protected static String createUrl(String url) {
        return String.format("<a href=\"%s\">", url);
    }

    protected static String createDefaultDeltaMessage(String url, int newWarnings, int fixedWarnings) {
        HtmlPrinter summary = new HtmlPrinter();
        if (newWarnings > 0) {
            summary.append(summary.item(summary.link(url + "/new", BuildResult.createNewWarningsLinkName(newWarnings))));
        }
        if (fixedWarnings > 0) {
            summary.append(summary.item(summary.link(url + "/fixed", BuildResult.createFixedWarningsLinkName(fixedWarnings))));
        }
        return summary.toString();
    }

    private static String createNewWarningsLinkName(int newWarnings) {
        if (newWarnings == 1) {
            return Messages.ResultAction_OneNewWarning();
        }
        return Messages.ResultAction_MultipleNewWarnings(newWarnings);
    }

    private static String createFixedWarningsLinkName(int fixedWarnings) {
        if (fixedWarnings == 1) {
            return Messages.ResultAction_OneFixedWarning();
        }
        return Messages.ResultAction_MultipleFixedWarnings(fixedWarnings);
    }

    public abstract String getSummary();

    public String getDetails() {
        HtmlPrinter printer = new HtmlPrinter();
        printer.append(this.createDeltaMessage());
        if (this.getNumberOfAnnotations() == 0 && this.getDelta() == 0) {
            printer.append(printer.item(Messages.ResultAction_NoWarningsSince(this.getZeroWarningsSinceBuild())));
            printer.append(printer.item(this.createHighScoreMessage()));
        } else if (this.isSuccessfulTouched()) {
            printer.append(printer.item(this.createPluginResultMessage()));
            if (this.isSuccessful()) {
                printer.append(printer.item(this.createSuccessfulHighScoreMessage()));
            }
        }
        return printer.toString();
    }

    private String createPluginResultMessage() {
        return Messages.ResultAction_Status() + this.getResultIcon() + " - " + this.getReason() + this.getReferenceBuildUrl();
    }

    private String getReferenceBuildUrl() {
        HtmlPrinter printer = new HtmlPrinter();
        if (this.hasReferenceBuild()) {
            Run<?, ?> build = this.getReferenceBuild();
            printer.append("&nbsp;");
            printer.append("(");
            printer.append(Messages.ReferenceBuild());
            printer.append(": ");
            printer.append(printer.link(Jenkins.getInstance().getRootUrl() + "/" + build.getUrl(), build.getDisplayName()));
            printer.append(")");
        }
        return printer.toString();
    }

    public String getResultIcon() {
        String message = "<img src=\"" + Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH + "/images/16x16/%s\" alt=\"%s\" title=\"%s\"/>";
        if (this.pluginResult == Result.FAILURE) {
            return String.format(message, FAILED, hudson.model.Messages.BallColor_Failed(), hudson.model.Messages.BallColor_Failed());
        }
        if (this.pluginResult == Result.UNSTABLE) {
            return String.format(message, UNSTABLE, hudson.model.Messages.BallColor_Unstable(), hudson.model.Messages.BallColor_Unstable());
        }
        return String.format(message, SUCCESS, hudson.model.Messages.BallColor_Success(), hudson.model.Messages.BallColor_Success());
    }

    public String getHeader() {
        return "";
    }

    protected String createDeltaMessage() {
        return "";
    }

    private String createHighScoreMessage() {
        if (this.isNewZeroWarningsHighScore()) {
            long days = BuildResult.getDays(this.getZeroWarningsHighScore());
            if (days == 1L) {
                return Messages.ResultAction_OneHighScore();
            }
            return Messages.ResultAction_MultipleHighScore(days);
        }
        long days = BuildResult.getDays(this.getHighScoreGap());
        if (days == 1L) {
            return Messages.ResultAction_OneNoHighScore();
        }
        return Messages.ResultAction_MultipleNoHighScore(days);
    }

    private String createSuccessfulHighScoreMessage() {
        if (this.isNewSuccessfulHighScore()) {
            long days = BuildResult.getDays(this.getSuccessfulHighScore());
            if (days == 1L) {
                return Messages.ResultAction_SuccessfulOneHighScore();
            }
            return Messages.ResultAction_SuccessfulMultipleHighScore(days);
        }
        long days = BuildResult.getDays(this.getSuccessfulHighScoreGap());
        if (days == 1L) {
            return Messages.ResultAction_SuccessfulOneNoHighScore();
        }
        return Messages.ResultAction_SuccessfulMultipleNoHighScore(days);
    }

    public String toString() {
        return this.getDisplayName() + " : " + this.getNumberOfAnnotations() + " annotations";
    }

    @Deprecated
    public BuildResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result, BuildHistory history) {
        this.initialize(history, (Run<?, ?>)build, defaultEncoding, result);
        this.serializeAnnotations(result.getAnnotations());
    }

    @Deprecated
    public BuildResult(AbstractBuild<?, ?> build, String defaultEncoding, ParserResult result) {
        this.initialize(this.createHistory(build), (Run<?, ?>)build, defaultEncoding, result);
        this.serializeAnnotations(result.getAnnotations());
    }

    @Deprecated
    protected BuildResult(AbstractBuild<?, ?> build, BuildHistory history, ParserResult result, String defaultEncoding) {
        this.initialize(history, (Run<?, ?>)build, defaultEncoding, result);
    }

    @Deprecated
    protected BuildHistory createHistory(AbstractBuild<?, ?> build) {
        return this.createHistory((Run<?, ?>)build);
    }
}

