/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.model.Result;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.ThresholdValidator;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import java.util.Collection;

public class BuildResultEvaluator {
    private final String url;

    public BuildResultEvaluator(String url) {
        this.url = url;
    }

    public Result evaluateBuildResult(StringBuilder logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations) {
        if (this.checkAllWarningsForFailure(logger, t, allAnnotations)) {
            return Result.FAILURE;
        }
        if (this.checkAllWarningsForUnstable(logger, t, allAnnotations)) {
            return Result.UNSTABLE;
        }
        return this.logSuccess(logger);
    }

    public Result evaluateBuildResult(StringBuilder logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations, int delta, int highDelta, int normalDelta, int lowDelta) {
        if (this.checkAllWarningsForFailure(logger, t, allAnnotations)) {
            return Result.FAILURE;
        }
        if (this.checkFailedNew(logger, delta, highDelta, normalDelta, lowDelta, t)) {
            return Result.FAILURE;
        }
        if (this.checkAllWarningsForUnstable(logger, t, allAnnotations)) {
            return Result.UNSTABLE;
        }
        if (this.checkUnstableNew(logger, delta, highDelta, normalDelta, lowDelta, t)) {
            return Result.UNSTABLE;
        }
        return this.logSuccess(logger);
    }

    public Result evaluateBuildResult(StringBuilder logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations, Collection<FileAnnotation> newAnnotations) {
        if (this.checkAllWarningsForFailure(logger, t, allAnnotations)) {
            return Result.FAILURE;
        }
        if (this.check(logger, newAnnotations, t.failedNewAll, t.failedNewHigh, t.failedNewNormal, t.failedNewLow, false)) {
            return Result.FAILURE;
        }
        if (this.checkAllWarningsForUnstable(logger, t, allAnnotations)) {
            return Result.UNSTABLE;
        }
        if (this.check(logger, newAnnotations, t.unstableNewAll, t.unstableNewHigh, t.unstableNewNormal, t.unstableNewLow, false)) {
            return Result.UNSTABLE;
        }
        return this.logSuccess(logger);
    }

    private boolean checkAllWarningsForUnstable(StringBuilder logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations) {
        return this.check(logger, allAnnotations, t.unstableTotalAll, t.unstableTotalHigh, t.unstableTotalNormal, t.unstableTotalLow, true);
    }

    private boolean checkAllWarningsForFailure(StringBuilder logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations) {
        return this.check(logger, allAnnotations, t.failedTotalAll, t.failedTotalHigh, t.failedTotalNormal, t.failedTotalLow, true);
    }

    private Result logSuccess(StringBuilder logger) {
        logger.append(Messages.BuildResultEvaluator_success());
        return Result.SUCCESS;
    }

    private boolean check(StringBuilder logger, Collection<? extends FileAnnotation> annotations, String all, String high, String normal, String low, boolean isTotals) {
        if (this.checkThresholds(logger, annotations, all, isTotals, Priority.HIGH, Priority.NORMAL, Priority.LOW)) {
            return true;
        }
        if (this.checkThresholds(logger, annotations, high, isTotals, Priority.HIGH)) {
            return true;
        }
        if (this.checkThresholds(logger, annotations, normal, isTotals, Priority.NORMAL)) {
            return true;
        }
        return this.checkThresholds(logger, annotations, low, isTotals, Priority.LOW);
    }

    private boolean checkFailedNew(StringBuilder logger, int delta, int highDelta, int normalDelta, int lowDelta, Thresholds t) {
        if (this.checkThresholds(logger, delta, t.failedNewAll, false, Priority.HIGH, Priority.NORMAL, Priority.LOW)) {
            return true;
        }
        if (this.checkThresholds(logger, highDelta, t.failedNewHigh, false, Priority.HIGH)) {
            return true;
        }
        if (this.checkThresholds(logger, normalDelta, t.failedNewNormal, false, Priority.NORMAL)) {
            return true;
        }
        return this.checkThresholds(logger, lowDelta, t.failedNewLow, false, Priority.LOW);
    }

    private boolean checkUnstableNew(StringBuilder logger, int delta, int highDelta, int normalDelta, int lowDelta, Thresholds t) {
        if (this.checkThresholds(logger, delta, t.unstableNewAll, false, Priority.HIGH, Priority.NORMAL, Priority.LOW)) {
            return true;
        }
        if (this.checkThresholds(logger, highDelta, t.unstableNewHigh, false, Priority.HIGH)) {
            return true;
        }
        if (this.checkThresholds(logger, normalDelta, t.unstableNewNormal, false, Priority.NORMAL)) {
            return true;
        }
        return this.checkThresholds(logger, lowDelta, t.unstableNewLow, false, Priority.LOW);
    }

    private boolean checkThresholds(StringBuilder logger, Collection<? extends FileAnnotation> allAnnotations, String threshold, boolean isTotals, Priority ... priorities) {
        return this.checkThresholds(logger, this.countAnnotations(allAnnotations, priorities), threshold, isTotals, priorities);
    }

    private boolean checkThresholds(StringBuilder logger, int annotationCount, String threshold, boolean isTotals, Priority ... priorities) {
        if (this.isAnnotationCountExceeded(annotationCount, threshold)) {
            int delta = annotationCount - ThresholdValidator.convert(threshold);
            if (isTotals) {
                this.createAllMessage(logger, annotationCount, threshold, delta, priorities);
            } else {
                this.createNewMessage(logger, annotationCount, threshold, delta, priorities);
            }
            return true;
        }
        return false;
    }

    private void createNewMessage(StringBuilder logger, int annotationCount, String threshold, int delta, Priority ... priorities) {
        String newUrl = this.url + "/new";
        if (priorities.length == 1) {
            Priority priority = priorities[0];
            if (annotationCount == 1) {
                logger.append(Messages.BuildResultEvaluator_unstable_one_new_priority(threshold, delta, priorities[0].getLocalizedString(), newUrl, this.getPriorityUrl(priority)));
            } else {
                logger.append(Messages.BuildResultEvaluator_unstable_new_priority(annotationCount, threshold, delta, priorities[0].getLocalizedString(), newUrl, this.getPriorityUrl(priority)));
            }
        } else if (annotationCount == 1) {
            logger.append(Messages.BuildResultEvaluator_unstable_one_new(threshold, delta, newUrl));
        } else {
            logger.append(Messages.BuildResultEvaluator_unstable_new(annotationCount, threshold, delta, newUrl));
        }
    }

    private void createAllMessage(StringBuilder logger, int annotationCount, String threshold, int delta, Priority ... priorities) {
        if (priorities.length == 1) {
            Priority priority = priorities[0];
            if (annotationCount == 1) {
                logger.append(Messages.BuildResultEvaluator_unstable_one_all_priority(threshold, delta, priorities[0].getLocalizedString(), this.url, this.getPriorityUrl(priority)));
            } else {
                logger.append(Messages.BuildResultEvaluator_unstable_all_priority(annotationCount, threshold, delta, priorities[0].getLocalizedString(), this.url, this.getPriorityUrl(priority)));
            }
        } else if (annotationCount == 1) {
            logger.append(Messages.BuildResultEvaluator_unstable_one_all(threshold, delta, this.url));
        } else {
            logger.append(Messages.BuildResultEvaluator_unstable_all(annotationCount, threshold, delta, this.url));
        }
    }

    private String getPriorityUrl(Priority priority) {
        return this.url + "/" + priority.name();
    }

    private int countAnnotations(Collection<? extends FileAnnotation> annotations, Priority ... priorities) {
        ParserResult result = new ParserResult(annotations);
        int annotationCount = 0;
        for (Priority priority : priorities) {
            annotationCount += result.getNumberOfAnnotations(priority);
        }
        return annotationCount;
    }

    public boolean isAnnotationCountExceeded(int annotationCount, String annotationThreshold) {
        if (annotationCount > 0 && ThresholdValidator.isValid(annotationThreshold)) {
            return annotationCount > ThresholdValidator.convert(annotationThreshold);
        }
        return false;
    }

    @Deprecated
    public Result evaluateBuildResult(PluginLogger logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations) {
        StringBuilder log = new StringBuilder();
        Result result = this.evaluateBuildResult(log, t, allAnnotations);
        logger.log(log.toString());
        return result;
    }

    @Deprecated
    public Result evaluateBuildResult(PluginLogger logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations, int delta, int highDelta, int normalDelta, int lowDelta) {
        StringBuilder log = new StringBuilder();
        Result result = this.evaluateBuildResult(log, t, allAnnotations, delta, highDelta, normalDelta, lowDelta);
        logger.log(log.toString());
        return result;
    }

    @Deprecated
    public Result evaluateBuildResult(PluginLogger logger, Thresholds t, Collection<? extends FileAnnotation> allAnnotations, Collection<FileAnnotation> newAnnotations) {
        StringBuilder log = new StringBuilder();
        Result result = this.evaluateBuildResult(log, t, allAnnotations, newAnnotations);
        logger.log(log.toString());
        return result;
    }
}

