/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.AnnotationParser;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.util.FileFinder;
import hudson.plugins.analysis.util.ModuleDetector;
import hudson.plugins.analysis.util.NullModuleDetector;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.StringPluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;

public class FilesParser
extends MasterToSlaveFileCallable<ParserResult> {
    private static final long serialVersionUID = -6415863872891783891L;
    @SuppressFBWarnings(value={"Se"})
    private transient StringPluginLogger stringLogger;
    private final String filePattern;
    private final AnnotationParser parser;
    private final boolean isMavenBuild;
    private final String moduleName;
    private boolean shouldDetectModules = true;
    private final String pluginId;
    private final boolean canResolveRelativePaths;

    private FilesParser(String filePattern, AnnotationParser parser, boolean isMavenBuild, String moduleName) {
        this.filePattern = filePattern;
        this.parser = parser;
        this.isMavenBuild = isMavenBuild;
        this.moduleName = moduleName;
        this.pluginId = "[ANALYSIS] ";
        this.canResolveRelativePaths = true;
    }

    private FilesParser(String pluginId, String filePattern, AnnotationParser parser, boolean shouldDetectModules, boolean isMavenBuild, String moduleName, boolean canResolveRelativePaths) {
        this.pluginId = pluginId;
        this.filePattern = filePattern;
        this.parser = parser;
        this.isMavenBuild = isMavenBuild;
        this.moduleName = moduleName;
        this.shouldDetectModules = shouldDetectModules;
        this.canResolveRelativePaths = canResolveRelativePaths;
    }

    public FilesParser(String pluginId, AnnotationParser parser, String moduleName) {
        this(pluginId, "", parser, true, true, moduleName, true);
    }

    public FilesParser(String pluginId, String filePattern, AnnotationParser parser, String moduleName) {
        this(pluginId, filePattern, parser, true, true, moduleName, true);
    }

    public FilesParser(String pluginId, String filePattern, AnnotationParser parser, boolean shouldDetectModules, boolean isMavenBuild) {
        this(pluginId, filePattern, parser, shouldDetectModules, isMavenBuild, true);
    }

    public FilesParser(String pluginId, String filePattern, AnnotationParser parser, boolean shouldDetectModules, boolean isMavenBuild, boolean canResolveRelativePaths) {
        this(pluginId, filePattern, parser, shouldDetectModules, isMavenBuild, "", canResolveRelativePaths);
    }

    protected void log(String message) {
        if (this.stringLogger == null) {
            this.stringLogger = new StringPluginLogger(this.pluginId);
        }
        this.stringLogger.log(message);
    }

    protected String plural(int count, String message) {
        if (count == 0 && !message.contains("%")) {
            return "";
        }
        String messageFormat = message;
        if (count != 1) {
            messageFormat = messageFormat + "s";
        }
        return String.format(messageFormat, count);
    }

    public ParserResult invoke(File workspace, VirtualChannel channel) throws IOException {
        ParserResult result = new ParserResult(new FilePath(workspace), this.canResolveRelativePaths);
        try {
            if (StringUtils.isBlank((String)this.filePattern)) {
                this.parseSingleFile(workspace, result);
            } else {
                this.parserCollectionOfFiles(workspace, result);
            }
        }
        catch (InterruptedException exception) {
            this.log("Parsing has been canceled.");
        }
        if (this.stringLogger != null) {
            result.setLog(this.stringLogger.toString());
        }
        for (FileAnnotation annotation : result.getAnnotations()) {
            annotation.setPathName(workspace.getAbsolutePath());
        }
        return result;
    }

    private void parserCollectionOfFiles(File workspace, ParserResult result) throws InterruptedException {
        this.log("Searching for all files in " + workspace.getAbsolutePath() + " that match the pattern " + this.filePattern);
        String[] fileNames = new FileFinder(this.filePattern).find(workspace);
        if (fileNames.length == 0) {
            this.log("No files found. Configuration error?");
            if (!this.isMavenBuild) {
                result.addErrorMessage(Messages.FilesParser_Error_NoFiles());
            }
        } else {
            this.log("Parsing " + this.plural(fileNames.length, "%d file") + " in " + workspace.getAbsolutePath());
            this.parseFiles(workspace, fileNames, result);
        }
    }

    private void parseSingleFile(File workspace, ParserResult result) throws InterruptedException {
        String[] fileNames = new String[]{workspace.getAbsolutePath()};
        this.log("Parsing file " + workspace.getAbsolutePath());
        this.parseFiles(workspace, fileNames, result);
    }

    private void parseFiles(File workspace, String[] fileNames, ParserResult result) throws InterruptedException {
        ModuleDetector detector = this.createModuleDetector(workspace);
        for (String fileName : fileNames) {
            String message;
            File file = new File(fileName);
            if (!file.isAbsolute()) {
                file = new File(workspace, fileName);
            }
            String module = this.getModuleName(detector, file);
            if (!file.canRead()) {
                message = Messages.FilesParser_Error_NoPermission(module, file);
                this.log(message);
                result.addErrorMessage(module, message);
                continue;
            }
            if (file.length() <= 0L) {
                message = Messages.FilesParser_Error_EmptyFile(module, file);
                this.log(message);
                result.addErrorMessage(module, message);
                continue;
            }
            this.parseFile(file, module, result);
            result.addModule(module);
        }
    }

    private ModuleDetector createModuleDetector(File workspace) {
        if (this.shouldDetectModules) {
            return new ModuleDetector(workspace);
        }
        return new NullModuleDetector();
    }

    private String getModuleName(ModuleDetector detector, File file) {
        String module = StringUtils.isBlank((String)this.moduleName) ? detector.guessModuleName(file.getAbsolutePath()) : this.moduleName;
        return module;
    }

    private void parseFile(File file, String module, ParserResult result) throws InterruptedException {
        try {
            Collection<FileAnnotation> annotations = this.parser.parse(file, module);
            int duplicateCount = annotations.size() - result.addAnnotations(annotations);
            int moduleCount = StringUtils.isBlank((String)module) ? 0 : 1;
            this.log("Successfully parsed file " + file + this.plural(moduleCount, " of module " + module) + " with " + this.plural(result.getNumberOfAnnotations(), "%d unique warning") + this.plural(duplicateCount, " and %d duplicate") + ".");
        }
        catch (InvocationTargetException exception) {
            String errorMessage = Messages.FilesParser_Error_Exception(file) + "\n\n" + ExceptionUtils.getStackTrace((Throwable)((Throwable)ObjectUtils.defaultIfNull((Object)exception.getCause(), (Object)exception)));
            result.addErrorMessage(module, errorMessage);
            this.log(errorMessage);
        }
    }

    @Deprecated
    public FilesParser(PluginLogger logger, String filePattern, AnnotationParser parser, boolean isMavenBuild) {
        this(filePattern, parser, isMavenBuild, "");
    }

    @Deprecated
    public FilesParser(PluginLogger logger, String filePattern, AnnotationParser parser, String moduleName) {
        this(filePattern, parser, true, moduleName);
    }

    @Deprecated
    public FilesParser(PluginLogger logger, String filePattern, AnnotationParser parser) {
        this(filePattern, parser, true, "");
        this.shouldDetectModules = false;
    }

    @Deprecated
    public FilesParser(StringPluginLogger logger, String filePattern, AnnotationParser parser, String moduleName) {
        this(filePattern, parser, true, moduleName);
    }

    @Deprecated
    public FilesParser(StringPluginLogger logger, String filePattern, AnnotationParser parser, boolean shouldDetectModules, boolean isMavenBuild) {
        this(filePattern, parser, isMavenBuild, "");
    }
}

