/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.LoggerFactory;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.DefaultAnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.plugins.analysis.util.model.WorkspaceFile;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

@Deprecated
public abstract class HealthAwareMavenReporter
extends MavenReporter
implements HealthDescriptor {
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final long serialVersionUID = 3003791883748835331L;
    private final String healthy;
    private final String unHealthy;
    private final String pluginName;
    private String thresholdLimit;
    private String defaultEncoding;
    private final boolean canRunOnFailed;
    private Thresholds thresholds = new Thresholds();
    @Deprecated
    private transient boolean thresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean healthyReportEnabled;
    @Deprecated
    private transient String height;
    @Deprecated
    private transient String threshold;
    @Deprecated
    private transient String failureThreshold;
    @Deprecated
    private transient String newFailureThreshold;
    @Deprecated
    private transient String newThreshold;

    public HealthAwareMavenReporter(String healthy, String unHealthy, String thresholdLimit, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, String pluginName) {
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = thresholdLimit;
        this.canRunOnFailed = canRunOnFailed;
        this.pluginName = "[" + pluginName + "] ";
        this.thresholds.unstableTotalAll = unstableTotalAll;
        this.thresholds.unstableTotalHigh = unstableTotalHigh;
        this.thresholds.unstableTotalNormal = unstableTotalNormal;
        this.thresholds.unstableTotalLow = unstableTotalLow;
        this.thresholds.unstableNewAll = unstableNewAll;
        this.thresholds.unstableNewHigh = unstableNewHigh;
        this.thresholds.unstableNewNormal = unstableNewNormal;
        this.thresholds.unstableNewLow = unstableNewLow;
        this.thresholds.failedTotalAll = failedTotalAll;
        this.thresholds.failedTotalHigh = failedTotalHigh;
        this.thresholds.failedTotalNormal = failedTotalNormal;
        this.thresholds.failedTotalLow = failedTotalLow;
        this.thresholds.failedNewAll = failedNewAll;
        this.thresholds.failedNewHigh = failedNewHigh;
        this.thresholds.failedNewNormal = failedNewNormal;
        this.thresholds.failedNewLow = failedNewLow;
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    @Deprecated
    public HealthAwareMavenReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, boolean canRunOnFailed, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, threshold, "", "", "", newThreshold, "", "", "", failureThreshold, "", "", "", newFailureThreshold, "", "", "", canRunOnFailed, pluginName);
    }

    @Deprecated
    public HealthAwareMavenReporter(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, threshold, "", "", "", newThreshold, "", "", "", failureThreshold, "", "", "", newFailureThreshold, "", "", "", false, pluginName);
    }

    @Override
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    @SuppressFBWarnings(value={"Se"})
    private Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        if (this.thresholds == null) {
            this.thresholds = new Thresholds();
            if (this.threshold != null) {
                this.thresholds.unstableTotalAll = this.threshold;
                this.threshold = null;
            }
            if (this.newThreshold != null) {
                this.thresholds.unstableNewAll = this.newThreshold;
                this.newThreshold = null;
            }
            if (this.failureThreshold != null) {
                this.thresholds.failedTotalAll = this.failureThreshold;
                this.failureThreshold = null;
            }
            if (this.newFailureThreshold != null) {
                this.thresholds.failedNewAll = this.newFailureThreshold;
                this.newFailureThreshold = null;
            }
        }
        return this;
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        PluginLogger logger = new LoggerFactory().createLogger(listener.getLogger(), this.pluginName);
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        Result currentResult = this.getCurrentResult(build);
        if (!this.canContinue(currentResult)) {
            logger.log("Skipping reporter since build result is " + currentResult);
            return true;
        }
        if (this.hasResultAction(build).booleanValue()) {
            logger.log("Skipping maven reporter: there is already a result available.");
            return true;
        }
        final ParserResult result = this.perform(build, pom, mojo, logger);
        this.defaultEncoding = pom.getProperties().getProperty("project.build.sourceEncoding");
        if (this.defaultEncoding == null) {
            logger.log(Messages.Reporter_Error_NoEncoding(Charset.defaultCharset().displayName()));
            result.addErrorMessage(pom.getName(), Messages.Reporter_Error_NoEncoding(Charset.defaultCharset().displayName()));
        }
        build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Void, IOException>(){

            public Void call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                HealthAwareMavenReporter.this.persistResult(result, mavenBuild);
                return null;
            }
        });
        this.copyFilesWithAnnotationsToBuildFolder(logger, build.getRootDir(), result.getAnnotations());
        return true;
    }

    private Result getCurrentResult(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Result)build.execute((MavenBuildProxy.BuildCallable)new BuildResultCallable());
    }

    public boolean getCanRunOnFailed() {
        return this.canRunOnFailed;
    }

    protected boolean canContinue(Result result) {
        if (this.canRunOnFailed) {
            return result != Result.ABORTED;
        }
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    private void copyFilesWithAnnotationsToBuildFolder(PluginLogger logger, FilePath buildRoot, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        FilePath directory = new FilePath(buildRoot, "workspace-files");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            FilePath masterFile = new FilePath(directory, file.getTempName());
            if (masterFile.exists()) continue;
            try {
                new FilePath((VirtualChannel)((Channel)null), file.getName()).copyTo(masterFile);
            }
            catch (IOException exception) {
                String message = "Can't copy source file: source=" + file.getName() + ", destination=" + masterFile.getName();
                logger.log(message);
                logger.printStackTrace(exception);
            }
        }
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PluginLogger var4) throws InterruptedException, IOException;

    protected abstract BuildResult persistResult(ParserResult var1, MavenBuild var2);

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Boolean, IOException>(){

            public Boolean call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                return mavenBuild.getAction(HealthAwareMavenReporter.this.getResultActionClass()) != null;
            }
        });
    }

    protected abstract Class<? extends Action> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath((VirtualChannel)null, pom.getBuild().getDirectory());
    }

    public String getThreshold() {
        return this.threshold;
    }

    public String getNewThreshold() {
        return this.newThreshold;
    }

    public String getFailureThreshold() {
        return this.failureThreshold;
    }

    public String getNewFailureThreshold() {
        return this.newFailureThreshold;
    }

    @Override
    public String getHealthy() {
        return this.healthy;
    }

    @Override
    public String getUnHealthy() {
        return this.unHealthy;
    }

    @Override
    public Priority getMinimumPriority() {
        return Priority.valueOf(StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }

    protected String getModuleName(MavenProject pom) {
        return StringUtils.defaultString((String)pom.getName(), (String)pom.getArtifactId());
    }

    private static final class BuildResultCallable
    implements MavenBuildProxy.BuildCallable<Result, IOException> {
        private static final long serialVersionUID = -270795641776014760L;

        private BuildResultCallable() {
        }

        public Result call(MavenBuild mavenBuild) throws IOException, InterruptedException {
            return mavenBuild.getResult();
        }
    }
}

