/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.GlobalSettings;
import hudson.plugins.analysis.core.HealthAwareRecorder;
import hudson.plugins.analysis.util.BlameFactory;
import hudson.plugins.analysis.util.Blamer;
import hudson.plugins.analysis.util.Compatibility;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import java.io.IOException;
import java.util.Set;

public abstract class HealthAwarePublisher
extends HealthAwareRecorder {
    private static final long serialVersionUID = -4225952809165635796L;

    public HealthAwarePublisher(String pluginName) {
        super(pluginName);
    }

    @Override
    protected boolean perform(Run<?, ?> run, FilePath workspace, Launcher launcher, PluginLogger logger) throws IOException, InterruptedException {
        BuildResult result;
        try {
            result = this.perform(run, workspace, logger);
            Run<?, ?> referenceBuild = result.getHistory().getReferenceBuild();
            if (GlobalSettings.instance().getFailOnCorrupt().booleanValue() && result.hasError()) {
                return false;
            }
            if (referenceBuild != null) {
                logger.log("Computing warning deltas based on reference build " + referenceBuild.getDisplayName());
            }
        }
        catch (InterruptedException exception) {
            logger.log(exception.getMessage());
            return false;
        }
        if (this.isThresholdEnabled()) {
            this.updateBuildResult(result, logger);
        }
        this.copyFilesWithAnnotationsToBuildFolder(run.getRootDir(), launcher.getChannel(), result.getAnnotations());
        return true;
    }

    protected void blame(Set<FileAnnotation> annotations, Run<?, ?> run, FilePath workspace) {
        if (GlobalSettings.instance().getNoAuthors().booleanValue()) {
            return;
        }
        Blamer blamer = BlameFactory.createBlamer(run, workspace, this.getListener());
        blamer.blame(annotations);
    }

    protected void updateBuildResult(BuildResult result, PluginLogger logger) {
        String baseUrl = this.getDescriptor().getPluginResultUrlName();
        result.evaluateStatus(this.getThresholds(), this.getUseDeltaValues(), this.canComputeNew(), logger, baseUrl);
    }

    @Deprecated
    protected BuildResult perform(AbstractBuild<?, ?> build, PluginLogger logger) throws InterruptedException, IOException {
        return this.perform((Run<?, ?>)build, null, logger);
    }

    protected BuildResult perform(Run<?, ?> run, FilePath workspace, PluginLogger logger) throws InterruptedException, IOException {
        if (run instanceof AbstractBuild && Compatibility.isOverridden(HealthAwarePublisher.class, this.getClass(), "perform", AbstractBuild.class, PluginLogger.class)) {
            return this.perform((AbstractBuild)run, logger);
        }
        throw new AbstractMethodError("you must override the new overload of perform(Run, FilePath, Launcher, PluginLogger)");
    }

    @Deprecated
    public HealthAwarePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean shouldDetectModules, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, shouldDetectModules, true, pluginName);
    }

    @Deprecated
    public HealthAwarePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, pluginName);
    }

    @Deprecated
    public HealthAwarePublisher(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, boolean canRunOnFailed, String pluginName) {
        super(threshold, newThreshold, failureThreshold, newFailureThreshold, healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, canRunOnFailed, pluginName);
    }

    @Deprecated
    public HealthAwarePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean useStableBuildAsReference, boolean shouldDetectModules, boolean canComputeNew, boolean canResolveRelativePaths, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, useStableBuildAsReference, shouldDetectModules, canComputeNew, canResolveRelativePaths, pluginName);
    }

    @Deprecated
    public HealthAwarePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean shouldDetectModules, boolean canComputeNew, boolean canResolveRelativePaths, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, shouldDetectModules, canComputeNew, canResolveRelativePaths, pluginName);
    }

    @Deprecated
    public HealthAwarePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean shouldDetectModules, boolean canComputeNew, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, shouldDetectModules, canComputeNew, true, pluginName);
    }

    @Deprecated
    public HealthAwarePublisher(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, boolean shouldDetectModules, boolean canComputeNew, boolean canResolveRelativePaths, String pluginName) {
        super(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, usePreviousBuildAsReference, useStableBuildAsReference, shouldDetectModules, canComputeNew, canResolveRelativePaths, pluginName);
    }
}

