/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.matrix.MatrixAggregatable;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Project;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.analysis.core.AntBuilderCheck;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.NullHealthDescriptor;
import hudson.plugins.analysis.core.PluginDescriptor;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.Files;
import hudson.plugins.analysis.util.LoggerFactory;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.remoting.VirtualChannel;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.tasks.Maven;
import hudson.tasks.Recorder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.CheckForNull;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class HealthAwareRecorder
extends Recorder
implements HealthDescriptor,
MatrixAggregatable,
SimpleBuildStep {
    private static final long serialVersionUID = 8892994325541840827L;
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final int RESOLVE_VARIABLES_DEPTH = 10;
    private String healthy;
    private String unHealthy;
    private String thresholdLimit = "low";
    private final String pluginName;
    private String defaultEncoding;
    private boolean canRunOnFailed;
    private boolean usePreviousBuildAsReference;
    private boolean useStableBuildAsReference;
    private boolean useDeltaValues;
    private Thresholds thresholds = new Thresholds();
    private boolean shouldDetectModules;
    private boolean dontComputeNew;
    private boolean doNotResolveRelativePaths;
    private transient TaskListener listener;
    @Deprecated
    private transient String threshold;
    @Deprecated
    private transient String newThreshold;
    @Deprecated
    private transient String failureThreshold;
    @Deprecated
    private transient String newFailureThreshold;
    @Deprecated
    private transient boolean thresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean healthyReportEnabled;
    @Deprecated
    private transient String height;

    protected HealthAwareRecorder(String pluginName) {
        this.pluginName = "[" + pluginName + "] ";
    }

    public Collection<? extends Action> getProjectActions(AbstractProject<?, ?> project) {
        return Collections.emptyList();
    }

    protected String expandFilePattern(String filePattern, EnvVars envVars) {
        String old;
        String expanded = filePattern;
        for (int i = 0; i < 10 && StringUtils.isNotBlank((String)expanded) && !(old = expanded).equals(expanded = Util.replaceMacro((String)expanded, (Map)envVars)); ++i) {
        }
        return expanded;
    }

    public boolean getCanResolveRelativePaths() {
        return !this.doNotResolveRelativePaths;
    }

    public boolean canResolveRelativePaths() {
        return this.getCanResolveRelativePaths();
    }

    protected boolean isThresholdEnabled() {
        return new NullHealthDescriptor(this).isThresholdEnabled();
    }

    public boolean usePreviousBuildAsReference() {
        return this.getUsePreviousBuildAsReference();
    }

    public boolean getUsePreviousBuildAsReference() {
        return this.usePreviousBuildAsReference;
    }

    @DataBoundSetter
    public void setUsePreviousBuildAsReference(boolean usePreviousBuildAsReference) {
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
    }

    public boolean getUseStableBuildAsReference() {
        return this.useStableBuildAsReference;
    }

    @DataBoundSetter
    public void setUseStableBuildAsReference(boolean useStableBuildAsReference) {
        this.useStableBuildAsReference = useStableBuildAsReference;
    }

    public boolean useOnlyStableBuildsAsReference() {
        return this.getUseStableBuildAsReference();
    }

    protected Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        if (this.thresholds == null) {
            this.thresholds = new Thresholds();
            if (this.threshold != null) {
                this.thresholds.unstableTotalAll = this.threshold;
                this.threshold = null;
            }
            if (this.newThreshold != null) {
                this.thresholds.unstableNewAll = this.newThreshold;
                this.newThreshold = null;
            }
            if (this.failureThreshold != null) {
                this.thresholds.failedTotalAll = this.failureThreshold;
                this.failureThreshold = null;
            }
            if (this.newFailureThreshold != null) {
                this.thresholds.failedNewAll = this.newFailureThreshold;
                this.newFailureThreshold = null;
            }
        }
        return this;
    }

    public final void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        this.setListener(listener);
        PluginLogger logger = new LoggerFactory().createLogger(listener.getLogger(), this.pluginName);
        if (this.canContinue(run.getResult())) {
            this.perform(run, workspace, launcher, logger);
        } else {
            logger.log("Skipping publisher since build result is " + run.getResult());
        }
    }

    protected abstract boolean perform(Run<?, ?> var1, FilePath var2, Launcher var3, PluginLogger var4) throws InterruptedException, IOException;

    public PluginDescriptor getDescriptor() {
        return (PluginDescriptor)super.getDescriptor();
    }

    protected void copyFilesWithAnnotationsToBuildFolder(File rootDir, VirtualChannel channel, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        new Files().copyFilesWithAnnotationsToBuildFolder(channel, new FilePath(rootDir), annotations, EncodingValidator.getEncoding(this.getDefaultEncoding()));
    }

    public boolean getCanComputeNew() {
        return this.canComputeNew();
    }

    public boolean canComputeNew() {
        return !this.dontComputeNew;
    }

    public boolean getCanRunOnFailed() {
        return this.canRunOnFailed;
    }

    @DataBoundSetter
    public void setCanRunOnFailed(boolean canRunOnFailed) {
        this.canRunOnFailed = canRunOnFailed;
    }

    public boolean getShouldDetectModules() {
        return this.shouldDetectModules;
    }

    @DataBoundSetter
    public void setShouldDetectModules(boolean shouldDetectModules) {
        this.shouldDetectModules = shouldDetectModules;
    }

    public boolean shouldDetectModules() {
        return this.shouldDetectModules;
    }

    protected boolean canContinue(Result result) {
        if (this.canRunOnFailed) {
            return result != Result.ABORTED;
        }
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    @Override
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    public boolean getUseDeltaValues() {
        return this.useDeltaValues;
    }

    @DataBoundSetter
    public void setUseDeltaValues(boolean useDeltaValues) {
        this.useDeltaValues = useDeltaValues;
    }

    @Override
    @CheckForNull
    public String getHealthy() {
        return this.healthy;
    }

    @DataBoundSetter
    public void setHealthy(String healthy) {
        this.healthy = healthy;
    }

    @Override
    @CheckForNull
    public String getUnHealthy() {
        return this.unHealthy;
    }

    @DataBoundSetter
    public void setUnHealthy(String unHealthy) {
        this.unHealthy = unHealthy;
    }

    @CheckForNull
    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    @DataBoundSetter
    public void setDefaultEncoding(String defaultEncoding) {
        this.defaultEncoding = defaultEncoding;
    }

    protected boolean isMavenBuild(Run<?, ?> build) {
        if (build instanceof AbstractBuild) {
            return this.isMavenBuild((AbstractBuild)build);
        }
        return false;
    }

    @Deprecated
    protected boolean isMavenBuild(AbstractBuild<?, ?> build) {
        if (build.getProject() instanceof Project) {
            Project project = (Project)build.getProject();
            for (Builder builder : project.getBuilders()) {
                if (!(builder instanceof Maven)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean isAntBuild(AbstractBuild<?, ?> build) {
        try {
            return AntBuilderCheck.isAntBuild(build);
        }
        catch (Throwable exception) {
            return false;
        }
    }

    @Override
    public Priority getMinimumPriority() {
        return Priority.valueOf(StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    @CheckForNull
    public String getThresholdLimit() {
        return this.thresholdLimit;
    }

    @DataBoundSetter
    public void setThresholdLimit(String thresholdLimit) {
        this.thresholdLimit = StringUtils.defaultIfEmpty((String)thresholdLimit, (String)DEFAULT_PRIORITY_THRESHOLD_LIMIT);
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @DataBoundSetter
    public void setCanResolveRelativePaths(boolean canResolveRelativePaths) {
        this.doNotResolveRelativePaths = !canResolveRelativePaths;
    }

    @DataBoundSetter
    public void setCanComputeNew(boolean canComputeNew) {
        this.dontComputeNew = !canComputeNew;
    }

    @CheckForNull
    public String getUnstableTotalAll() {
        return this.thresholds.unstableTotalAll;
    }

    @DataBoundSetter
    public void setUnstableTotalAll(String unstableTotalAll) {
        this.thresholds.unstableTotalAll = unstableTotalAll;
    }

    @CheckForNull
    public String getUnstableTotalHigh() {
        return this.thresholds.unstableTotalHigh;
    }

    @DataBoundSetter
    public void setUnstableTotalHigh(String unstableTotalHigh) {
        this.thresholds.unstableTotalHigh = unstableTotalHigh;
    }

    @CheckForNull
    public String getUnstableTotalNormal() {
        return this.thresholds.unstableTotalNormal;
    }

    @DataBoundSetter
    public void setUnstableTotalNormal(String unstableTotalNormal) {
        this.thresholds.unstableTotalNormal = unstableTotalNormal;
    }

    @CheckForNull
    public String getUnstableTotalLow() {
        return this.thresholds.unstableTotalLow;
    }

    @DataBoundSetter
    public void setUnstableTotalLow(String unstableTotalLow) {
        this.thresholds.unstableTotalLow = unstableTotalLow;
    }

    @CheckForNull
    public String getUnstableNewAll() {
        return this.thresholds.unstableNewAll;
    }

    @DataBoundSetter
    public void setUnstableNewAll(String unstableNewAll) {
        this.thresholds.unstableNewAll = unstableNewAll;
    }

    @CheckForNull
    public String getUnstableNewHigh() {
        return this.thresholds.unstableNewHigh;
    }

    @DataBoundSetter
    public void setUnstableNewHigh(String unstableNewHigh) {
        this.thresholds.unstableNewHigh = unstableNewHigh;
    }

    @CheckForNull
    public String getUnstableNewNormal() {
        return this.thresholds.unstableNewNormal;
    }

    @DataBoundSetter
    public void setUnstableNewNormal(String unstableNewNormal) {
        this.thresholds.unstableNewNormal = unstableNewNormal;
    }

    @CheckForNull
    public String getUnstableNewLow() {
        return this.thresholds.unstableNewLow;
    }

    @DataBoundSetter
    public void setUnstableNewLow(String unstableNewLow) {
        this.thresholds.unstableNewLow = unstableNewLow;
    }

    @CheckForNull
    public String getFailedTotalAll() {
        return this.thresholds.failedTotalAll;
    }

    @DataBoundSetter
    public void setFailedTotalAll(String failedTotalAll) {
        this.thresholds.failedTotalAll = failedTotalAll;
    }

    @CheckForNull
    public String getFailedTotalHigh() {
        return this.thresholds.failedTotalHigh;
    }

    @DataBoundSetter
    public void setFailedTotalHigh(String failedTotalHigh) {
        this.thresholds.failedTotalHigh = failedTotalHigh;
    }

    @CheckForNull
    public String getFailedTotalNormal() {
        return this.thresholds.failedTotalNormal;
    }

    @DataBoundSetter
    public void setFailedTotalNormal(String failedTotalNormal) {
        this.thresholds.failedTotalNormal = failedTotalNormal;
    }

    @CheckForNull
    public String getFailedTotalLow() {
        return this.thresholds.failedTotalLow;
    }

    @DataBoundSetter
    public void setFailedTotalLow(String failedTotalLow) {
        this.thresholds.failedTotalLow = failedTotalLow;
    }

    @CheckForNull
    public String getFailedNewAll() {
        return this.thresholds.failedNewAll;
    }

    @DataBoundSetter
    public void setFailedNewAll(String failedNewAll) {
        this.thresholds.failedNewAll = failedNewAll;
    }

    @CheckForNull
    public String getFailedNewHigh() {
        return this.thresholds.failedNewHigh;
    }

    @DataBoundSetter
    public void setFailedNewHigh(String failedNewHigh) {
        this.thresholds.failedNewHigh = failedNewHigh;
    }

    @CheckForNull
    public String getFailedNewNormal() {
        return this.thresholds.failedNewNormal;
    }

    @DataBoundSetter
    public void setFailedNewNormal(String failedNewNormal) {
        this.thresholds.failedNewNormal = failedNewNormal;
    }

    @CheckForNull
    public String getFailedNewLow() {
        return this.thresholds.failedNewLow;
    }

    @DataBoundSetter
    public void setFailedNewLow(String failedNewLow) {
        this.thresholds.failedNewLow = failedNewLow;
    }

    private void setListener(TaskListener listener) {
        this.listener = listener;
    }

    protected TaskListener getListener() {
        if (this.listener == null) {
            return TaskListener.NULL;
        }
        return this.listener;
    }

    @Deprecated
    public HealthAwareRecorder(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean useStableBuildAsReference, boolean shouldDetectModules, boolean canComputeNew, boolean canResolveRelativePaths, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, useStableBuildAsReference, shouldDetectModules, canComputeNew, canResolveRelativePaths, pluginName);
    }

    @Deprecated
    public HealthAwareRecorder(String threshold, String newThreshold, String failureThreshold, String newFailureThreshold, String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, boolean canRunOnFailed, String pluginName) {
        this.thresholds.unstableTotalAll = threshold;
        this.thresholds.unstableNewAll = newThreshold;
        this.thresholds.failedTotalAll = failureThreshold;
        this.thresholds.failedNewAll = newFailureThreshold;
        this.doNotResolveRelativePaths = false;
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = thresholdLimit;
        this.defaultEncoding = defaultEncoding;
        this.useDeltaValues = useDeltaValues;
        this.canRunOnFailed = canRunOnFailed;
        this.usePreviousBuildAsReference = false;
        this.useStableBuildAsReference = false;
        this.dontComputeNew = false;
        this.shouldDetectModules = false;
        this.pluginName = "[" + pluginName + "] ";
    }

    @Deprecated
    public HealthAwareRecorder(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean shouldDetectModules, boolean canComputeNew, boolean canResolveRelativePaths, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, defaultEncoding, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, shouldDetectModules, canComputeNew, canResolveRelativePaths, pluginName);
    }

    @Deprecated
    public HealthAwareRecorder(String healthy, String unHealthy, String thresholdLimit, String defaultEncoding, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, boolean shouldDetectModules, boolean canComputeNew, boolean canResolveRelativePaths, String pluginName) {
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = StringUtils.defaultIfEmpty((String)thresholdLimit, (String)DEFAULT_PRIORITY_THRESHOLD_LIMIT);
        this.defaultEncoding = defaultEncoding;
        this.useDeltaValues = useDeltaValues;
        this.doNotResolveRelativePaths = !canResolveRelativePaths;
        this.dontComputeNew = !canComputeNew;
        this.thresholds.unstableTotalAll = unstableTotalAll;
        this.thresholds.unstableTotalHigh = unstableTotalHigh;
        this.thresholds.unstableTotalNormal = unstableTotalNormal;
        this.thresholds.unstableTotalLow = unstableTotalLow;
        this.thresholds.unstableNewAll = unstableNewAll;
        this.thresholds.unstableNewHigh = unstableNewHigh;
        this.thresholds.unstableNewNormal = unstableNewNormal;
        this.thresholds.unstableNewLow = unstableNewLow;
        this.thresholds.failedTotalAll = failedTotalAll;
        this.thresholds.failedTotalHigh = failedTotalHigh;
        this.thresholds.failedTotalNormal = failedTotalNormal;
        this.thresholds.failedTotalLow = failedTotalLow;
        this.thresholds.failedNewAll = failedNewAll;
        this.thresholds.failedNewHigh = failedNewHigh;
        this.thresholds.failedNewNormal = failedNewNormal;
        this.thresholds.failedNewLow = failedNewLow;
        this.canRunOnFailed = canRunOnFailed;
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
        this.useStableBuildAsReference = useStableBuildAsReference;
        this.shouldDetectModules = shouldDetectModules;
        this.pluginName = "[" + pluginName + "] ";
    }
}

