/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.Launcher;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenBuildProxy;
import hudson.maven.MavenModuleSetBuild;
import hudson.maven.MavenReporter;
import hudson.maven.MojoInfo;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.GlobalSettings;
import hudson.plugins.analysis.core.HealthDescriptor;
import hudson.plugins.analysis.core.MavenResultAction;
import hudson.plugins.analysis.core.NullHealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ReporterDescriptor;
import hudson.plugins.analysis.core.SerializableSettings;
import hudson.plugins.analysis.core.Settings;
import hudson.plugins.analysis.core.Thresholds;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.Files;
import hudson.plugins.analysis.util.LoggerFactory;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.StringPluginLogger;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import hudson.remoting.VirtualChannel;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;

public abstract class HealthAwareReporter<T extends BuildResult>
extends MavenReporter
implements HealthDescriptor {
    private static final String DEFAULT_PRIORITY_THRESHOLD_LIMIT = "low";
    private static final long serialVersionUID = -5369644266347796143L;
    private final String healthy;
    private final String unHealthy;
    private final String pluginName;
    private String thresholdLimit;
    private String defaultEncoding;
    private final boolean canRunOnFailed;
    private final boolean useDeltaValues;
    private Thresholds thresholds = new Thresholds();
    private final boolean dontComputeNew;
    private final boolean usePreviousBuildAsReference;
    private final boolean useStableBuildAsReference;
    @Deprecated
    private transient boolean thresholdEnabled;
    @Deprecated
    private transient int minimumAnnotations;
    @Deprecated
    private transient int healthyAnnotations;
    @Deprecated
    private transient int unHealthyAnnotations;
    @Deprecated
    private transient boolean healthyReportEnabled;
    @Deprecated
    private transient String height;
    @Deprecated
    private transient String threshold;
    @Deprecated
    private transient String failureThreshold;
    @Deprecated
    private transient String newFailureThreshold;
    @Deprecated
    private transient String newThreshold;

    public HealthAwareReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean usePreviousBuildAsReference, boolean useStableBuildAsReference, boolean canComputeNew, String pluginName) {
        this.healthy = healthy;
        this.unHealthy = unHealthy;
        this.thresholdLimit = StringUtils.defaultIfEmpty((String)thresholdLimit, (String)DEFAULT_PRIORITY_THRESHOLD_LIMIT);
        this.canRunOnFailed = canRunOnFailed;
        this.usePreviousBuildAsReference = usePreviousBuildAsReference;
        this.useStableBuildAsReference = useStableBuildAsReference;
        this.dontComputeNew = !canComputeNew;
        this.pluginName = "[" + pluginName + "] ";
        this.useDeltaValues = useDeltaValues;
        this.thresholds.unstableTotalAll = unstableTotalAll;
        this.thresholds.unstableTotalHigh = unstableTotalHigh;
        this.thresholds.unstableTotalNormal = unstableTotalNormal;
        this.thresholds.unstableTotalLow = unstableTotalLow;
        this.thresholds.unstableNewAll = unstableNewAll;
        this.thresholds.unstableNewHigh = unstableNewHigh;
        this.thresholds.unstableNewNormal = unstableNewNormal;
        this.thresholds.unstableNewLow = unstableNewLow;
        this.thresholds.failedTotalAll = failedTotalAll;
        this.thresholds.failedTotalHigh = failedTotalHigh;
        this.thresholds.failedTotalNormal = failedTotalNormal;
        this.thresholds.failedTotalLow = failedTotalLow;
        this.thresholds.failedNewAll = failedNewAll;
        this.thresholds.failedNewHigh = failedNewHigh;
        this.thresholds.failedNewNormal = failedNewNormal;
        this.thresholds.failedNewLow = failedNewLow;
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.Jdk14Logger");
    }

    public boolean getCanComputeNew() {
        return this.canComputeNew();
    }

    public boolean canComputeNew() {
        return !this.dontComputeNew;
    }

    public boolean getUseDeltaValues() {
        return this.useDeltaValues;
    }

    public boolean getUsePreviousBuildAsReference() {
        return this.usePreviousBuildAsReference;
    }

    public boolean usePreviousBuildAsReference() {
        return this.getUsePreviousBuildAsReference();
    }

    public boolean getUseStableBuildAsReference() {
        return this.useStableBuildAsReference;
    }

    public boolean useOnlyStableBuildsAsReference() {
        return this.getUseStableBuildAsReference();
    }

    @Override
    public Thresholds getThresholds() {
        return this.thresholds;
    }

    @SuppressFBWarnings(value={"Se"})
    private Object readResolve() {
        if (this.thresholdLimit == null) {
            this.thresholdLimit = DEFAULT_PRIORITY_THRESHOLD_LIMIT;
        }
        if (this.thresholds == null) {
            this.thresholds = new Thresholds();
            if (this.threshold != null) {
                this.thresholds.unstableTotalAll = this.threshold;
                this.threshold = null;
            }
            if (this.newThreshold != null) {
                this.thresholds.unstableNewAll = this.newThreshold;
                this.newThreshold = null;
            }
            if (this.failureThreshold != null) {
                this.thresholds.failedTotalAll = this.failureThreshold;
                this.failureThreshold = null;
            }
            if (this.newFailureThreshold != null) {
                this.thresholds.failedNewAll = this.newFailureThreshold;
                this.newFailureThreshold = null;
            }
        }
        return this;
    }

    public final boolean postExecute(MavenBuildProxy build, MavenProject pom, MojoInfo mojo, BuildListener listener, Throwable error) throws InterruptedException, IOException {
        ParserResult result;
        if (!this.acceptGoal(mojo.getGoal())) {
            return true;
        }
        Result currentResult = this.getCurrentResult(build);
        PluginLogger logger = new LoggerFactory(this.receiveSettingsFromMaster(build)).createLogger(listener.getLogger(), this.pluginName);
        if (!this.canContinue(currentResult)) {
            logger.log("Skipping reporter since build result is " + currentResult);
            return true;
        }
        if (this.hasResultAction(build).booleanValue()) {
            return true;
        }
        try {
            result = this.perform(build, pom, mojo, logger);
            if (result.getModules().isEmpty() && result.getNumberOfAnnotations() == 0) {
                logger.log("No report found for mojo " + mojo.getGoal());
                return true;
            }
        }
        catch (InterruptedException exception) {
            logger.log(exception.getMessage());
            return false;
        }
        logger.logLines(result.getLogMessages());
        this.setEncoding(pom, result, logger);
        this.registerResultsOnMaster(build, result, logger);
        this.copyFilesWithAnnotationsToBuildFolder(logger, build.getRootDir(), result.getAnnotations());
        return true;
    }

    private void registerResultsOnMaster(MavenBuildProxy build, final ParserResult result, PluginLogger logger) throws IOException, InterruptedException {
        String resultLog = (String)build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<String, IOException>(){

            public String call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                return HealthAwareReporter.this.registerResults(result, mavenBuild);
            }
        });
        logger.logLines(resultLog);
    }

    private void setEncoding(MavenProject pom, ParserResult result, PluginLogger logger) {
        this.defaultEncoding = pom.getProperties().getProperty("project.build.sourceEncoding");
        if (this.defaultEncoding == null) {
            logger.log(Messages.Reporter_Error_NoEncoding(Charset.defaultCharset().displayName()));
            result.addErrorMessage(pom.getName(), Messages.Reporter_Error_NoEncoding(Charset.defaultCharset().displayName()));
        }
    }

    private Settings receiveSettingsFromMaster(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Settings)build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Settings, IOException>(){

            public Settings call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                return new SerializableSettings(GlobalSettings.instance());
            }
        });
    }

    private String registerResults(ParserResult result, MavenBuild mavenBuild) {
        T buildResult = this.createResult(mavenBuild, result);
        StringPluginLogger pluginLogger = new StringPluginLogger(this.pluginName);
        if (new NullHealthDescriptor(this).isThresholdEnabled()) {
            String baseUrl = this.getDescriptor().getPluginResultUrlName();
            ((BuildResult)buildResult).evaluateStatus(this.thresholds, this.useDeltaValues, this.canComputeNew(), pluginLogger, baseUrl);
        }
        mavenBuild.addAction((Action)this.createMavenAggregatedReport(mavenBuild, buildResult));
        mavenBuild.registerAsProjectAction((MavenReporter)this);
        Run<?, ?> referenceBuild = ((BuildResult)buildResult).getHistory().getReferenceBuild();
        if (referenceBuild != null) {
            pluginLogger.log("Computing warning deltas based on reference build " + referenceBuild.getDisplayName());
        }
        return pluginLogger.toString();
    }

    public ReporterDescriptor getDescriptor() {
        return (ReporterDescriptor)super.getDescriptor();
    }

    public boolean end(MavenBuild build, Launcher launcher, BuildListener listener) {
        MavenResultAction action;
        MavenModuleSetBuild moduleSetBuild = build.getParentBuild();
        if (moduleSetBuild != null && (action = (MavenResultAction)moduleSetBuild.getAction(this.getResultActionClass())) != null) {
            listener.getLogger().append(action.getLog());
        }
        return true;
    }

    private Result getCurrentResult(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Result)build.execute((MavenBuildProxy.BuildCallable)new BuildResultCallable());
    }

    public boolean getCanRunOnFailed() {
        return this.canRunOnFailed;
    }

    protected boolean canContinue(Result result) {
        if (this.canRunOnFailed) {
            return result != Result.ABORTED;
        }
        return result != Result.ABORTED && result != Result.FAILURE;
    }

    private void copyFilesWithAnnotationsToBuildFolder(PluginLogger logger, FilePath buildRoot, Collection<FileAnnotation> annotations) throws IOException, FileNotFoundException, InterruptedException {
        new Files().copyFilesWithAnnotationsToBuildFolder(null, buildRoot, annotations, EncodingValidator.getEncoding(this.getDefaultEncoding()));
    }

    protected abstract boolean acceptGoal(String var1);

    protected abstract ParserResult perform(MavenBuildProxy var1, MavenProject var2, MojoInfo var3, PluginLogger var4) throws InterruptedException, IOException;

    protected abstract T createResult(MavenBuild var1, ParserResult var2);

    protected abstract MavenAggregatedReport createMavenAggregatedReport(MavenBuild var1, T var2);

    protected String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    private Boolean hasResultAction(MavenBuildProxy build) throws IOException, InterruptedException {
        return (Boolean)build.execute((MavenBuildProxy.BuildCallable)new MavenBuildProxy.BuildCallable<Boolean, IOException>(){

            public Boolean call(MavenBuild mavenBuild) throws IOException, InterruptedException {
                return mavenBuild.getAction(HealthAwareReporter.this.getResultActionClass()) != null;
            }
        });
    }

    protected abstract Class<? extends MavenResultAction<T>> getResultActionClass();

    protected FilePath getTargetPath(MavenProject pom) {
        return new FilePath((VirtualChannel)null, pom.getBuild().getDirectory());
    }

    @Override
    public String getHealthy() {
        return this.healthy;
    }

    @Override
    public String getUnHealthy() {
        return this.unHealthy;
    }

    @Override
    public Priority getMinimumPriority() {
        return Priority.valueOf(StringUtils.upperCase((String)this.getThresholdLimit()));
    }

    public String getThresholdLimit() {
        return this.thresholdLimit;
    }

    protected String getModuleName(MavenProject pom) {
        return StringUtils.defaultIfEmpty((String)pom.getName(), (String)pom.getArtifactId());
    }

    @Deprecated
    public HealthAwareReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean useStableBuildAsReference, boolean canComputeNew, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, useStableBuildAsReference, canComputeNew, pluginName);
    }

    @Deprecated
    public HealthAwareReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, boolean canComputeNew, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, false, canComputeNew, pluginName);
    }

    @Deprecated
    public HealthAwareReporter(String healthy, String unHealthy, String thresholdLimit, boolean useDeltaValues, String unstableTotalAll, String unstableTotalHigh, String unstableTotalNormal, String unstableTotalLow, String unstableNewAll, String unstableNewHigh, String unstableNewNormal, String unstableNewLow, String failedTotalAll, String failedTotalHigh, String failedTotalNormal, String failedTotalLow, String failedNewAll, String failedNewHigh, String failedNewNormal, String failedNewLow, boolean canRunOnFailed, String pluginName) {
        this(healthy, unHealthy, thresholdLimit, useDeltaValues, unstableTotalAll, unstableTotalHigh, unstableTotalNormal, unstableTotalLow, unstableNewAll, unstableNewHigh, unstableNewNormal, unstableNewLow, failedTotalAll, failedTotalHigh, failedTotalNormal, failedTotalLow, failedNewAll, failedNewHigh, failedNewNormal, failedNewLow, canRunOnFailed, true, pluginName);
    }

    @Deprecated
    public boolean getUsePreviousBuildAsStable() {
        return this.getUsePreviousBuildAsReference();
    }

    @Deprecated
    public boolean usePreviousBuildAsStable() {
        return this.usePreviousBuildAsReference();
    }

    private static final class BuildResultCallable
    implements MavenBuildProxy.BuildCallable<Result, IOException> {
        private static final long serialVersionUID = -270795641776014760L;

        private BuildResultCallable() {
        }

        public Result call(MavenBuild mavenBuild) throws IOException, InterruptedException {
            return mavenBuild.getResult();
        }
    }
}

