/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.HealthReport;
import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.util.model.AnnotationProvider;
import hudson.plugins.analysis.util.model.Priority;
import java.io.Serializable;

public class HealthReportBuilder
implements Serializable {
    private static final long serialVersionUID = 5191317904662711835L;
    private final AbstractHealthDescriptor healthDescriptor;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int healthy;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int unHealthy;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient boolean isHealthEnabled;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient boolean isThresholdEnabled;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient int threshold;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient String reportName;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient String itemName;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient String reportSingleCount;
    @Deprecated
    @SuppressFBWarnings(value={"SE"})
    private transient String reportMultipleCount;

    public HealthReportBuilder(AbstractHealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    public HealthReport computeHealth(AnnotationProvider result) {
        int numberOfAnnotations = 0;
        for (Priority priority : Priority.collectPrioritiesFrom(this.healthDescriptor.getMinimumPriority())) {
            numberOfAnnotations += result.getNumberOfAnnotations(priority);
        }
        return this.computeHealth(numberOfAnnotations, result);
    }

    protected HealthReport computeHealth(int counter, AnnotationProvider result) {
        if (this.healthDescriptor.isHealthyReportEnabled()) {
            int percentage = counter < this.healthDescriptor.getHealthyAnnotations() ? 100 : (counter > this.healthDescriptor.getUnHealthyAnnotations() ? 0 : 100 - (counter - this.healthDescriptor.getHealthyAnnotations()) * 100 / (this.healthDescriptor.getUnHealthyAnnotations() - this.healthDescriptor.getHealthyAnnotations()));
            return new HealthReport(percentage, this.healthDescriptor.createDescription(result));
        }
        return null;
    }
}

