/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import hudson.plugins.analysis.util.model.FileAnnotation;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;

public class IssueDifference {
    private final Set<FileAnnotation> newIssues;
    private final Set<FileAnnotation> fixedIssues;

    public IssueDifference(Set<FileAnnotation> currentIssues, Set<FileAnnotation> referenceIssues) {
        this.newIssues = new HashSet<FileAnnotation>(currentIssues);
        this.fixedIssues = new HashSet<FileAnnotation>(referenceIssues);
        HashSet<FileAnnotation> oldIssues = new HashSet<FileAnnotation>();
        for (FileAnnotation current : currentIssues) {
            FileAnnotation referenceToRemove = this.findReferenceByEquals(current);
            if (referenceToRemove == null) {
                referenceToRemove = this.findReferenceByContext(current);
            }
            if (referenceToRemove == null) continue;
            oldIssues.add(current);
            this.newIssues.remove(current);
            this.fixedIssues.remove(referenceToRemove);
            current.setBuild(referenceToRemove.getBuild());
        }
    }

    @CheckForNull
    private FileAnnotation findReferenceByContext(FileAnnotation current) {
        for (FileAnnotation reference : this.fixedIssues) {
            if (current.getContextHashCode() != reference.getContextHashCode()) continue;
            return reference;
        }
        return null;
    }

    @CheckForNull
    private FileAnnotation findReferenceByEquals(FileAnnotation current) {
        for (FileAnnotation reference : this.fixedIssues) {
            if (!current.equals(reference)) continue;
            return reference;
        }
        return null;
    }

    public Set<FileAnnotation> getNewIssues() {
        return this.newIssues;
    }

    public Set<FileAnnotation> getFixedIssues() {
        return this.fixedIssues;
    }
}

