/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.FilePath;
import hudson.maven.AggregatableAction;
import hudson.maven.MavenAggregatedReport;
import hudson.maven.MavenBuild;
import hudson.maven.MavenModule;
import hudson.model.AbstractBuild;
import hudson.model.HealthReport;
import hudson.model.Result;
import hudson.model.Run;
import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.AbstractResultAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.NullHealthDescriptor;
import hudson.plugins.analysis.core.ParserResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.util.PluginLogger;
import hudson.plugins.analysis.util.StringPluginLogger;
import hudson.plugins.analysis.util.ToolTipProvider;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.StaplerProxy;

@BridgeMethodsAdded
public abstract class MavenResultAction<T extends BuildResult>
implements StaplerProxy,
AggregatableAction,
MavenAggregatedReport,
ResultAction<T> {
    private final String defaultEncoding;
    private final AbstractResultAction<T> delegate;
    private transient StringPluginLogger logger;
    private transient Set<MavenModule> modules = Sets.newHashSet();
    private final transient String pluginName;

    public MavenResultAction(AbstractResultAction<T> delegate, String defaultEncoding, String pluginName) {
        this.defaultEncoding = defaultEncoding;
        this.delegate = delegate;
        this.pluginName = pluginName;
    }

    public abstract Class<? extends MavenResultAction<T>> getIndividualActionType();

    public String getSmallImageName() {
        return this.delegate.getSmallImageName();
    }

    protected abstract T createResult(T var1, T var2);

    public void update(Map<MavenModule, List<MavenBuild>> moduleBuilds, MavenBuild newBuild) {
        MavenResultAction additionalAction = (MavenResultAction)newBuild.getAction(this.getIndividualActionType());
        MavenModule project = (MavenModule)newBuild.getProject();
        if (additionalAction != null && !this.getModules().contains(project)) {
            T existingResult = this.delegate.getResult();
            T additionalResult = additionalAction.getResult();
            if (newBuild.getResult().isBetterThan(Result.FAILURE) || ((BuildResult)additionalResult).getPluginResult().isWorseOrEqualTo(Result.FAILURE)) {
                this.getModules().add(project);
                this.setResult(this.createAggregatedResult(existingResult, additionalResult));
                this.copySourceFilesToModuleBuildFolder(newBuild);
            }
        }
    }

    private void copySourceFilesToModuleBuildFolder(MavenBuild newBuild) {
        FilePath filePath = new FilePath(new File(newBuild.getRootDir(), "workspace-files"));
        try {
            filePath.copyRecursiveTo("*.tmp", new FilePath(new File(this.getOwner().getRootDir(), "workspace-files")));
        }
        catch (IOException exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't copy workspace files: ", exception);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private T createAggregatedResult(@CheckForNull T existingResult, T additionalResult) {
        T createdResult = this.createResult(existingResult, additionalResult);
        if (new NullHealthDescriptor(this.delegate.getHealthDescriptor()).isThresholdEnabled()) {
            ((BuildResult)createdResult).evaluateStatus(((BuildResult)additionalResult).getThresholds(), ((BuildResult)additionalResult).canUseDeltaValues(), this.getLogger(), this.getUrlName());
        }
        return createdResult;
    }

    protected ParserResult aggregate(@CheckForNull T existingResult, T additionalResult) {
        ParserResult aggregatedAnnotations = new ParserResult();
        ArrayList results = Lists.newArrayList();
        if (existingResult != null) {
            results.add(existingResult);
        }
        results.add(additionalResult);
        for (BuildResult result : results) {
            aggregatedAnnotations.addAnnotations(result.getAnnotations());
            aggregatedAnnotations.addModules(result.getModules());
            aggregatedAnnotations.addErrors(result.getErrors());
        }
        return aggregatedAnnotations;
    }

    private PluginLogger getLogger() {
        if (this.logger == null) {
            this.logger = this.createLogger();
        }
        return this.logger;
    }

    private StringPluginLogger createLogger() {
        return new StringPluginLogger("[" + StringUtils.defaultString((String)this.pluginName, (String)"ANALYSIS") + "] ");
    }

    private Set<MavenModule> getModules() {
        if (this.modules == null) {
            this.modules = Sets.newHashSet();
        }
        return this.modules;
    }

    public String getLog() {
        String message = this.getLogger().toString();
        this.logger = this.createLogger();
        return message;
    }

    public String getDefaultEncoding() {
        return this.defaultEncoding;
    }

    public boolean hasLargeImage() {
        return this.delegate.hasLargeImage();
    }

    public String getLargeImageName() {
        return this.delegate.getLargeImageName();
    }

    public String getIconFileName() {
        return this.delegate.getIconFileName();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getUrlName() {
        return this.delegate.getUrlName();
    }

    @Override
    public void setResult(T additionalResult) {
        this.delegate.setResult(additionalResult);
    }

    @Override
    public T getResult() {
        return this.delegate.getResult();
    }

    public boolean useOnlyStableBuildsAsReference() {
        return ((BuildResult)this.delegate.getResult()).useOnlyStableBuildsAsReference();
    }

    public boolean usePreviousBuildAsStable() {
        return ((BuildResult)this.delegate.getResult()).usePreviousBuildAsStable();
    }

    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public Run<?, ?> getOwner() {
        return this.delegate.getOwner();
    }

    @Deprecated
    private Object getAbstractBuild(Run owner, Class targetClass) {
        return this.delegate.getOwner() instanceof AbstractBuild ? (AbstractBuild)this.delegate.getOwner() : null;
    }

    public final HealthReport getBuildHealth() {
        return this.delegate.getBuildHealth();
    }

    @Override
    public ToolTipProvider getToolTipProvider() {
        return this.delegate.getToolTipProvider();
    }

    @Override
    @WithBridgeMethods(value={AbstractBuild.class}, adapterMethod="getAbstractBuild")
    public final Run<?, ?> getBuild() {
        return this.delegate.getOwner();
    }

    public final Object getTarget() {
        return this.delegate.getTarget();
    }

    public String getTooltip(int numberOfItems) {
        return this.delegate.getTooltip(numberOfItems);
    }

    @Override
    public boolean isSuccessful() {
        return this.delegate.isSuccessful();
    }

    @Override
    public AbstractHealthDescriptor getHealthDescriptor() {
        return this.delegate.getHealthDescriptor();
    }
}

