/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.FilePath;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.util.FileFinder;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.Priority;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

@BridgeMethodsAdded
public class ParserResult
implements Serializable {
    private static final long serialVersionUID = -8414545334379193330L;
    private static final Logger LOGGER = Logger.getLogger(ParserResult.class.getName());
    private static final String SLASH = "/";
    private final Set<FileAnnotation> annotations = new HashSet<FileAnnotation>();
    private final List<String> errorMessages = new ArrayList<String>();
    private final Map<Priority, Integer> annotationCountByPriority = new HashMap<Priority, Integer>();
    private final Set<String> modules = new HashSet<String>();
    private final Workspace workspace;
    private transient Multimap<String, String> fileNameCache = HashMultimap.create();
    private String logMessage;
    private int numberOfModules;
    private final boolean canResolveRelativePaths;

    public ParserResult() {
        this(new NullWorkspace());
    }

    public ParserResult(FilePath workspace) {
        this(ParserResult.asWorkspace(workspace));
    }

    public ParserResult(Workspace workspace) {
        this(workspace, false);
    }

    public ParserResult(FilePath workspace, boolean canResolveRelativePaths) {
        this(ParserResult.asWorkspace(workspace), canResolveRelativePaths);
    }

    public ParserResult(Workspace workspace, boolean canResolveRelativePaths) {
        this.workspace = workspace;
        this.canResolveRelativePaths = canResolveRelativePaths;
        for (Priority priority : Priority.values()) {
            this.annotationCountByPriority.put(priority, 0);
        }
    }

    private static FilePathAdapter asWorkspace(FilePath workspace) {
        return new FilePathAdapter(workspace);
    }

    public ParserResult(Collection<? extends FileAnnotation> annotations) {
        this(new NullWorkspace());
        this.addAnnotations(annotations);
    }

    public void addProject(ParserResult additionalProject) {
        this.addAnnotations(additionalProject.getAnnotations());
        this.addErrors(additionalProject.getErrorMessages());
        this.addModules(additionalProject.getModules());
    }

    private void expandRelativePaths(FileAnnotation annotation) {
        try {
            if (this.hasRelativeFileName(annotation)) {
                Workspace remoteFile = this.workspace.child(annotation.getFileName());
                if (remoteFile.exists()) {
                    annotation.setFileName(remoteFile.getPath());
                } else if (this.canResolveRelativePaths) {
                    this.findFileByScanningAllWorkspaceFiles(annotation);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void findFileByScanningAllWorkspaceFiles(FileAnnotation annotation) throws IOException, InterruptedException {
        String baseName;
        if (this.fileNameCache.isEmpty()) {
            this.populateFileNameCache();
        }
        if (this.fileNameCache.containsKey((Object)(baseName = FilenameUtils.getName((String)annotation.getFileName())))) {
            int matchesCount = 0;
            String absoluteFileName = null;
            for (String match : this.fileNameCache.get((Object)baseName)) {
                String annotationFileName;
                String strippedFileName;
                if (!match.contains(strippedFileName = this.stripRelativePrefix(annotationFileName = annotation.getFileName()))) continue;
                absoluteFileName = this.workspace.getPath() + SLASH + match;
                ++matchesCount;
            }
            if (matchesCount == 1) {
                annotation.setFileName(absoluteFileName);
            } else if (matchesCount == 0) {
                LOGGER.log(Level.FINE, String.format("Absolute filename could not be resolved for: %s. Found no matches in cache: %s. ", annotation.getFileName(), this.fileNameCache.get((Object)baseName)));
            } else {
                LOGGER.log(Level.FINE, String.format("Absolute filename could not be resolved for: %s. Found multiple matches in cache: %s. ", annotation.getFileName(), this.fileNameCache.get((Object)baseName)));
            }
        } else {
            LOGGER.log(Level.FINE, String.format("Absolute filename could not be resolved for: %s. No such file in workspace: %s. ", annotation.getFileName(), this.workspace.getPath()));
        }
    }

    String stripRelativePrefix(String annotationFileName) {
        return StringUtils.removePattern((String)annotationFileName, (String)".*(\\.\\.?/)+");
    }

    private void populateFileNameCache() throws IOException, InterruptedException {
        String[] allFiles;
        LOGGER.log(Level.FINE, "Building cache of all workspace files to obtain absolute filenames for all warnings: " + this.workspace.getPath());
        for (String file : allFiles = this.workspace.findFiles("**/*")) {
            this.fileNameCache.put((Object)FilenameUtils.getName((String)file), (Object)FilenameUtils.separatorsToUnix((String)file));
        }
    }

    private boolean hasRelativeFileName(FileAnnotation annotation) {
        String fileName = annotation.getFileName();
        return StringUtils.isNotBlank((CharSequence)fileName) && !fileName.startsWith(SLASH) && !fileName.contains(":");
    }

    @WithBridgeMethods(value={void.class})
    public final int addAnnotation(FileAnnotation annotation) {
        this.expandRelativePaths(annotation);
        if (this.annotations.add(annotation)) {
            Integer count = this.annotationCountByPriority.get((Object)annotation.getPriority());
            this.annotationCountByPriority.put(annotation.getPriority(), count + 1);
            return 1;
        }
        return 0;
    }

    @WithBridgeMethods(value={void.class})
    public final int addAnnotations(Collection<? extends FileAnnotation> newAnnotations) {
        int count = 0;
        for (FileAnnotation fileAnnotation : newAnnotations) {
            count += this.addAnnotation(fileAnnotation);
        }
        return count;
    }

    public final void addAnnotations(FileAnnotation[] newAnnotations) {
        this.addAnnotations(Arrays.asList(newAnnotations));
    }

    public void addErrorMessage(String module, String message) {
        this.errorMessages.add(Messages.Result_Error_ModuleErrorMessage(module, message));
    }

    public void addErrorMessage(String message) {
        this.errorMessages.add(message);
    }

    public void addErrors(List<String> errors) {
        this.errorMessages.addAll(errors);
    }

    public List<String> getErrorMessages() {
        return ImmutableList.copyOf(this.errorMessages);
    }

    public Set<FileAnnotation> getAnnotations() {
        return ImmutableSet.copyOf(this.annotations);
    }

    public int getNumberOfAnnotations() {
        return this.annotations.size();
    }

    public int getNumberOfAnnotations(Priority priority) {
        return this.annotationCountByPriority.get((Object)priority);
    }

    public boolean hasAnnotations() {
        return !this.annotations.isEmpty();
    }

    public boolean hasAnnotations(Priority priority) {
        return this.annotationCountByPriority.get((Object)priority) > 0;
    }

    public boolean hasNoAnnotations() {
        return !this.hasAnnotations();
    }

    public boolean hasNoAnnotations(Priority priority) {
        return !this.hasAnnotations(priority);
    }

    public int getNumberOfModules() {
        return this.numberOfModules;
    }

    public Set<String> getModules() {
        return Collections.unmodifiableSet(this.modules);
    }

    public void addModule(String moduleName) {
        this.modules.add(moduleName);
        ++this.numberOfModules;
    }

    public void addModules(Collection<String> additionalModules) {
        this.modules.addAll(additionalModules);
    }

    public String toString() {
        return this.getNumberOfAnnotations() + " annotations";
    }

    public void setLog(String message) {
        this.logMessage = message;
    }

    public String getLogMessages() {
        return StringUtils.defaultString((String)this.logMessage);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.fileNameCache = HashMultimap.create();
    }

    private static class NullWorkspace
    implements Workspace {
        private static final long serialVersionUID = 2307259492760554066L;

        private NullWorkspace() {
        }

        @Override
        public Workspace child(String fileName) {
            return this;
        }

        @Override
        public boolean exists() throws IOException, InterruptedException {
            return false;
        }

        @Override
        public String getPath() {
            return "";
        }

        @Override
        public String[] findFiles(String pattern) throws IOException, InterruptedException {
            return new String[0];
        }
    }

    private static class FilePathAdapter
    implements Workspace {
        private static final long serialVersionUID = 1976601889843466249L;
        private final FilePath wrapped;

        FilePathAdapter(FilePath workspace) {
            this.wrapped = workspace;
        }

        @Override
        public Workspace child(String fileName) {
            return ParserResult.asWorkspace(this.wrapped.child(fileName));
        }

        @Override
        public boolean exists() throws IOException, InterruptedException {
            return this.wrapped.exists();
        }

        @Override
        public String getPath() {
            return this.wrapped.getRemote();
        }

        @Override
        public String[] findFiles(String pattern) throws IOException, InterruptedException {
            return (String[])this.wrapped.act((FilePath.FileCallable)new FileFinder(pattern));
        }
    }

    static interface Workspace
    extends Serializable {
        public Workspace child(String var1);

        public boolean exists() throws InterruptedException, IOException;

        public String getPath();

        public String[] findFiles(String var1) throws IOException, InterruptedException;
    }
}

