/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.plugins.analysis.core.MavenProjectChecker;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.EncodingValidator;
import hudson.plugins.analysis.util.ThresholdValidator;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.QueryParameter;

public abstract class PluginDescriptor
extends BuildStepDescriptor<Publisher> {
    protected static final String RESULT_URL_SUFFIX = "Result";
    private static final String COMPUTE_NEW_SECTION_KEY = "canComputeNew";

    public static String createResultUrlName(String pluginName) {
        return pluginName + RESULT_URL_SUFFIX;
    }

    public static boolean isPluginInstalled(String shortName) {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            return instance.getPlugin(shortName) != null;
        }
        return true;
    }

    public static boolean isMavenPluginInstalled() {
        return PluginDescriptor.isPluginInstalled("maven-plugin");
    }

    @Deprecated
    protected static JSONObject convertHierarchicalFormData(JSONObject hierarchical) {
        return PluginDescriptor.convertHierarchicalFormData(hierarchical, COMPUTE_NEW_SECTION_KEY);
    }

    @Deprecated
    @SuppressFBWarnings(value={"WMI"})
    protected static JSONObject convertHierarchicalFormData(JSONObject hierarchical, String section) {
        if (hierarchical.containsKey((Object)section)) {
            JSONObject newSection = hierarchical.getJSONObject(section);
            JSONObject output = JSONObject.fromObject((Object)hierarchical);
            output.remove(section);
            for (Object key : newSection.keySet()) {
                output.element((String)key, newSection.get(key));
            }
            output.element(section, true);
            return output;
        }
        return hierarchical;
    }

    public PluginDescriptor(Class<? extends Publisher> clazz) {
        super(clazz);
    }

    public final String getHelpFile() {
        return this.getPluginRoot() + "help.html";
    }

    public String getPluginRoot() {
        return "/plugin/" + this.getPluginName() + "/";
    }

    public final String getPluginResultUrlName() {
        return PluginDescriptor.createResultUrlName(this.getPluginName());
    }

    public abstract String getPluginName();

    public abstract String getIconUrl();

    public String getSummaryIconUrl() {
        return "";
    }

    public FormValidation doCheckDefaultEncoding(@QueryParameter String defaultEncoding) {
        try {
            return new EncodingValidator().check(defaultEncoding);
        }
        catch (FormValidation exception) {
            return exception;
        }
    }

    public FormValidation doCheckPattern(@AncestorInPath AbstractProject<?, ?> project, @QueryParameter String pattern) throws IOException {
        if (project != null) {
            try {
                String result;
                FilePath workspace = project.getSomeWorkspace();
                if (workspace != null && workspace.exists() && (result = workspace.validateAntFileMask(pattern, FilePath.VALIDATE_ANT_FILE_MASK_BOUND)) != null) {
                    return FormValidation.error((String)result);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return FormValidation.ok();
    }

    public FormValidation doCheckThreshold(@QueryParameter String threshold) {
        try {
            return new ThresholdValidator().check(threshold);
        }
        catch (FormValidation exception) {
            return exception;
        }
    }

    public FormValidation doCheckHeight(@QueryParameter String height) {
        return GraphConfiguration.checkHeight(height);
    }

    public boolean isApplicable(Class<? extends AbstractProject> jobType) {
        return !PluginDescriptor.isMavenPluginInstalled() || !MavenProjectChecker.isMavenProject(jobType);
    }
}

