/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.core;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.analysis.util.ThresholdValidator;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
@SuppressFBWarnings(value={""})
public class Thresholds
implements Serializable {
    @Exported
    public String unstableTotalAll = "";
    @Exported
    public String unstableTotalHigh = "";
    @Exported
    public String unstableTotalNormal = "";
    @Exported
    public String unstableTotalLow = "";
    @Exported
    public String unstableNewAll = "";
    @Exported
    public String unstableNewHigh = "";
    @Exported
    public String unstableNewNormal = "";
    @Exported
    public String unstableNewLow = "";
    @Exported
    public String failedTotalAll = "";
    @Exported
    public String failedTotalHigh = "";
    @Exported
    public String failedTotalNormal = "";
    @Exported
    public String failedTotalLow = "";
    @Exported
    public String failedNewAll = "";
    @Exported
    public String failedNewHigh = "";
    @Exported
    public String failedNewNormal = "";
    @Exported
    public String failedNewLow = "";

    public boolean isValid() {
        return Thresholds.isValid(this.unstableTotalAll) || Thresholds.isValid(this.unstableTotalHigh) || Thresholds.isValid(this.unstableTotalNormal) || Thresholds.isValid(this.unstableTotalLow) || Thresholds.isValid(this.unstableNewAll) || Thresholds.isValid(this.unstableNewHigh) || Thresholds.isValid(this.unstableNewNormal) || Thresholds.isValid(this.unstableNewLow) || Thresholds.isValid(this.failedTotalAll) || Thresholds.isValid(this.failedTotalHigh) || Thresholds.isValid(this.failedTotalNormal) || Thresholds.isValid(this.failedTotalLow) || Thresholds.isValid(this.failedNewAll) || Thresholds.isValid(this.failedNewHigh) || Thresholds.isValid(this.failedNewNormal) || Thresholds.isValid(this.failedNewLow);
    }

    public static boolean isValid(String threshold) {
        if (StringUtils.isNotBlank((String)threshold)) {
            try {
                return Integer.valueOf(threshold) >= 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public int getLowerBound() {
        if (Thresholds.isValid(this.unstableTotalAll)) {
            return ThresholdValidator.convert(this.unstableTotalAll);
        }
        if (Thresholds.isValid(this.failedTotalAll)) {
            return ThresholdValidator.convert(this.failedTotalAll);
        }
        return 0;
    }
}

