/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.dashboard;

import com.google.common.collect.Lists;
import hudson.model.Job;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.dashboard.AbstractPortlet;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.graph.NullGraph;
import hudson.util.Graph;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWarningsGraphPortlet
extends AbstractPortlet {
    private transient GraphConfiguration configuration;
    private final String width;
    private final String height;
    private final String dayCountString;

    public AbstractWarningsGraphPortlet(String name, String width, String height, String dayCountString) {
        super(name);
        this.width = width;
        this.height = height;
        this.dayCountString = dayCountString;
        this.configureGraph(new NullGraph());
    }

    protected final void configureGraph(BuildResultGraph graph) {
        this.configuration = new GraphConfiguration(graph);
        this.configuration.initializeFrom(this.width, this.height, this.dayCountString);
    }

    public String getDescription() {
        return String.format("[%s ...]", StringUtils.defaultString((String)this.getDescriptor().getDisplayName()));
    }

    private Object readResolve() {
        this.configureGraph(this.getGraphType());
        return this;
    }

    protected abstract BuildResultGraph getGraphType();

    public Graph getWarningsGraph() {
        List<ResultAction<?>> results = this.getActions();
        BuildResultGraph graph = results.isEmpty() ? new NullGraph() : this.configuration.getGraphType();
        return graph.getGraph(-1L, this.configuration, this.getPluginName(), results);
    }

    protected abstract String getPluginName();

    public boolean isEmpty() {
        return this.getActions().isEmpty();
    }

    private List<ResultAction<?>> getActions() {
        ArrayList results = Lists.newArrayList();
        for (Job job : this.getDashboard().getJobs()) {
            AbstractProjectAction<?> action = this.selectAction(job);
            if (action == null || !action.hasValidResults()) continue;
            results.add(action.getLastAction());
        }
        return results;
    }

    protected AbstractProjectAction<?> selectAction(Job<?, ?> job) {
        return (AbstractProjectAction)job.getAction(this.getAction());
    }

    public int getHeight() {
        return this.configuration.getHeight();
    }

    public int getWidth() {
        return this.configuration.getWidth();
    }

    public String getDayCountString() {
        return this.configuration.getDayCount() > 0 ? Integer.toString(this.configuration.getDayCount()) : "";
    }
}

