/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.dashboard;

import com.google.common.collect.Lists;
import hudson.model.Job;
import hudson.plugins.analysis.core.AbstractProjectAction;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.dashboard.AbstractPortlet;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractWarningsTablePortlet
extends AbstractPortlet {
    private static final String CLOSE_TAG = ">";
    private static final String OPEN_TAG = "<";
    private static final String NO_RESULTS_FOUND = "-";
    private final boolean canHideZeroWarningsProjects;

    public AbstractWarningsTablePortlet(String name) {
        this(name, false);
    }

    public AbstractWarningsTablePortlet(String name, boolean canHideZeroWarningsProjects) {
        super(name);
        this.canHideZeroWarningsProjects = canHideZeroWarningsProjects;
    }

    public boolean getCanHideZeroWarningsProjects() {
        return this.canHideZeroWarningsProjects;
    }

    public Collection<Job<?, ?>> filterZeroWarningsJobs(Collection<Job<?, ?>> jobs) {
        if (this.canHideZeroWarningsProjects) {
            return this.filter(jobs);
        }
        return jobs;
    }

    protected Collection<Job<?, ?>> filter(Collection<Job<?, ?>> jobs) {
        ArrayList filtered = Lists.newArrayList();
        for (Job<?, ?> job : jobs) {
            if (!this.isVisibleJob(job)) continue;
            filtered.add(job);
        }
        return filtered;
    }

    protected boolean isVisibleJob(Job<?, ?> job) {
        return this.toInt(this.getWarnings(job)) > 0;
    }

    @Deprecated
    protected String getPluginName() {
        return "";
    }

    public String getWarnings(Collection<Job<?, ?>> jobs) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getWarnings(job));
        }
        return String.valueOf(sum);
    }

    public String getWarnings(Collection<Job<?, ?>> jobs, String priority) {
        int sum = 0;
        for (Job<?, ?> job : jobs) {
            sum += this.toInt(this.getWarnings(job, priority));
        }
        return String.valueOf(sum);
    }

    protected int toInt(String value) {
        try {
            if (value.contains(OPEN_TAG)) {
                return Integer.parseInt(StringUtils.substringBetween((String)value, (String)CLOSE_TAG, (String)OPEN_TAG));
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }

    public String getWarnings(Job<?, ?> job) {
        ResultAction<?> lastAction;
        AbstractProjectAction<?> action = this.selectAction(job);
        if (action != null && (lastAction = action.getLastAction()) != null) {
            String value;
            Object result = lastAction.getResult();
            int numberOfAnnotations = ((BuildResult)result).getNumberOfAnnotations();
            if (numberOfAnnotations > 0) {
                String prefix = this.getDashboard().getUrl();
                String jobUrl = job.getUrl().replaceFirst(prefix, "");
                value = String.format("<a href=\"%s%s\">%d</a>", jobUrl, action.getUrlName(), numberOfAnnotations);
            } else {
                value = String.valueOf(numberOfAnnotations);
            }
            if (((BuildResult)result).isSuccessfulTouched() && !((BuildResult)result).isSuccessful()) {
                return value + ((BuildResult)result).getResultIcon();
            }
            return value;
        }
        return NO_RESULTS_FOUND;
    }

    public String getWarnings(Job<?, ?> job, String priority) {
        ResultAction<?> lastAction;
        AbstractProjectAction<?> action = this.selectAction(job);
        if (action != null && (lastAction = action.getLastAction()) != null) {
            Object result = lastAction.getResult();
            return String.valueOf(((BuildResult)result).getNumberOfAnnotations(priority));
        }
        return NO_RESULTS_FOUND;
    }

    @CheckForNull
    protected AbstractProjectAction<?> selectAction(Job<?, ?> job) {
        if (job == null) {
            return null;
        }
        return (AbstractProjectAction)job.getAction(this.getAction());
    }
}

