/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.ColorPalette;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.util.DataSetBuilder;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.data.category.CategoryDataset;

public class AnnotationsByUserGraph
extends BuildResultGraph {
    @Override
    public JFreeChart create(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, @CheckForNull String pluginName) {
        HashMap<String, Integer[]> annotationCountByUser = new HashMap<String, Integer[]>();
        this.mergeResults(resultAction.getResult(), annotationCountByUser);
        return this.createGraphFromUserMapping(configuration, pluginName, annotationCountByUser, resultAction.getToolTipProvider());
    }

    private JFreeChart createGraphFromUserMapping(GraphConfiguration configuration, @CheckForNull String pluginName, Map<String, Integer[]> annotationCountByUser, ToolTipProvider toolTipProvider) {
        JFreeChart chart = this.createBlockChart(this.buildDataSet(annotationCountByUser));
        this.attachRenderers(configuration, pluginName, chart, toolTipProvider);
        return chart;
    }

    @Override
    public JFreeChart createAggregation(GraphConfiguration configuration, Collection<ResultAction<? extends BuildResult>> resultActions, String pluginName) {
        HashMap<String, Integer[]> annotationCountByUser = new HashMap<String, Integer[]>();
        for (ResultAction<? extends BuildResult> resultAction : resultActions) {
            this.mergeResults(resultAction.getResult(), annotationCountByUser);
        }
        return this.createGraphFromUserMapping(configuration, pluginName, annotationCountByUser, resultActions.iterator().next().getToolTipProvider());
    }

    private void attachRenderers(GraphConfiguration configuration, String pluginName, JFreeChart chart, ToolTipProvider toolTipProvider) {
        StackedBarRenderer renderer = new StackedBarRenderer();
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer((CategoryItemRenderer)renderer);
        this.setColors(chart, new Color[]{ColorPalette.BLUE, ColorPalette.YELLOW, ColorPalette.RED});
    }

    private CategoryDataset buildDataSet(Map<String, Integer[]> annotationCountByUser) {
        DataSetBuilder builder = new DataSetBuilder();
        for (Map.Entry<String, Integer[]> entry : annotationCountByUser.entrySet()) {
            String userName = entry.getKey();
            Integer[] countsPerPriority = entry.getValue();
            for (int i = 0; i < countsPerPriority.length; ++i) {
                builder.add((Number)countsPerPriority[i], (Comparable)((Object)Integer.toString(i)), (Comparable)((Object)userName));
            }
        }
        return builder.build();
    }

    private void mergeResults(BuildResult current, Map<String, Integer[]> annotationCountByUser) {
        Set<FileAnnotation> annotations = current.getAnnotations();
        for (FileAnnotation annotation : annotations) {
            String author = annotation.getAuthor();
            if (!StringUtils.isNotBlank((CharSequence)author) || "-".equals(author)) continue;
            if (annotationCountByUser.get(author) == null) {
                annotationCountByUser.put(author, new Integer[]{0, 0, 0});
            }
            Integer[] priorities = annotationCountByUser.get(author);
            int index = annotation.getPriority().ordinal();
            Integer[] integerArray = priorities;
            int n = index;
            Integer n2 = integerArray[n];
            Integer n3 = integerArray[n] = Integer.valueOf(integerArray[n] + 1);
        }
    }

    @Override
    public String getId() {
        return "USERS";
    }

    @Override
    public String getLabel() {
        return Messages.Trend_type_authors();
    }
}

