/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import com.google.common.base.Objects;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.graph.ColorPalette;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.util.Graph;
import hudson.util.ShiftedCategoryAxis;
import java.awt.Color;
import java.awt.Paint;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public abstract class BuildResultGraph {
    private static final int A_DAY_IN_MSEC = 86400000;
    private String rootUrl = "";

    public boolean isSelectable() {
        return true;
    }

    public abstract String getId();

    public abstract String getLabel();

    public String getExampleImage() {
        return "/plugin/" + this.getPlugin() + "/icons/" + this.getId() + ".png";
    }

    protected String getPlugin() {
        return "analysis-core";
    }

    public boolean isVisible() {
        return true;
    }

    public void setRootUrl(String rootUrl) {
        this.rootUrl = rootUrl;
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public abstract JFreeChart create(GraphConfiguration var1, ResultAction<? extends BuildResult> var2, @CheckForNull String var3);

    public abstract JFreeChart createAggregation(GraphConfiguration var1, Collection<ResultAction<? extends BuildResult>> var2, String var3);

    public static long computeDayDelta(Calendar first, Calendar second) {
        return Math.abs((first.getTimeInMillis() - second.getTimeInMillis()) / 86400000L);
    }

    public static long computeDayDelta(Calendar first, BuildResult second) {
        return BuildResultGraph.computeDayDelta(first, second.getOwner().getTimestamp());
    }

    public static boolean areResultsTooOld(GraphConfiguration configuration, BuildResult current) {
        GregorianCalendar today = new GregorianCalendar();
        return configuration.isDayCountDefined() && BuildResultGraph.computeDayDelta((Calendar)today, current) >= (long)configuration.getDayCount();
    }

    protected void setPlotProperties(Plot plot) {
        plot.setBackgroundPaint((Paint)Color.WHITE);
        plot.setOutlinePaint(null);
        plot.setForegroundAlpha(0.8f);
        plot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 5.0));
    }

    public JFreeChart createXYChart(XYDataset dataset) {
        JFreeChart chart = ChartFactory.createXYAreaChart(null, null, (String)"count", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = chart.getXYPlot();
        plot.setRenderer((XYItemRenderer)new XYDifferenceRenderer((Paint)ColorPalette.BLUE, (Paint)ColorPalette.RED, false));
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.setPlotProperties((Plot)plot);
        return chart;
    }

    public Graph getGraph(long timestamp, final GraphConfiguration configuration, final String pluginName, final ResultAction<?> lastAction) {
        return new Graph(timestamp, configuration.getWidth(), configuration.getHeight()){

            protected JFreeChart createGraph() {
                return BuildResultGraph.this.create(configuration, lastAction, pluginName);
            }
        };
    }

    public Graph getGraph(long timestamp, final GraphConfiguration configuration, final String pluginName, final Collection<ResultAction<?>> actions) {
        return new Graph(timestamp, configuration.getWidth(), configuration.getHeight()){

            protected JFreeChart createGraph() {
                return BuildResultGraph.this.createAggregation(configuration, actions, pluginName);
            }
        };
    }

    public boolean isDeactivated() {
        return false;
    }

    protected boolean isBuildTooOld(GraphConfiguration configuration, BuildResult current) {
        return BuildResultGraph.areResultsTooOld(configuration, current);
    }

    protected void setCategoryPlotProperties(CategoryPlot plot) {
        plot.setRangeGridlinesVisible(true);
        plot.setRangeGridlinePaint((Paint)Color.black);
        ShiftedCategoryAxis domainAxis = new ShiftedCategoryAxis(null);
        plot.setDomainAxis((CategoryAxis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setLowerMargin(0.0);
        domainAxis.setUpperMargin(0.0);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        this.setPlotProperties((Plot)plot);
    }

    public JFreeChart createBlockChart(CategoryDataset dataset) {
        return this.createBlockChart(dataset, "count");
    }

    public JFreeChart createBlockChart(CategoryDataset dataset, String yAxisLabel) {
        JFreeChart chart = ChartFactory.createStackedBarChart(null, null, (String)yAxisLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        this.setCategoryPlotProperties(chart.getCategoryPlot());
        return chart;
    }

    protected boolean passesFilteringByParameter(Run<?, ?> build, String parameterName, String parameterValue) {
        if (StringUtils.isBlank((String)parameterName)) {
            return true;
        }
        if (!(build instanceof AbstractBuild)) {
            return true;
        }
        Map variables = ((AbstractBuild)build).getBuildVariables();
        if (variables == null) {
            return false;
        }
        return Objects.equal(variables.get(parameterName), (Object)parameterValue);
    }

    public void setColors(JFreeChart chart, Color[] colors) {
        CategoryPlot plot = chart.getCategoryPlot();
        CategoryItemRenderer renderer = plot.getRenderer();
        int series = 0;
        for (Color color : colors) {
            renderer.setSeriesPaint(series, (Paint)color);
            ++series;
        }
    }
}

