/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Run;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.graph.LocalDateLabel;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.joda.time.LocalDate;

public abstract class CategoryBuildResultGraph
extends BuildResultGraph {
    private static final Font LEGEND_FONT = new Font("SansSerif", 0, 10);
    private static final String Y_AXIS_LABEL = Messages.Trend_yAxisLabel();

    @Override
    public JFreeChart create(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, String pluginName) {
        JFreeChart chart = this.createChart(configuration, resultAction);
        this.attachRenderers(configuration, pluginName, chart, resultAction.getToolTipProvider());
        return chart;
    }

    @Override
    @SuppressFBWarnings(value={"WMI"})
    public JFreeChart createAggregation(GraphConfiguration configuration, Collection<ResultAction<? extends BuildResult>> resultActions, String pluginName) {
        HashSet availableDates = Sets.newHashSet();
        HashMap averagesPerJob = Maps.newHashMap();
        for (ResultAction<? extends BuildResult> resultAction : resultActions) {
            Map<LocalDate, List<Integer>> averageByDate = this.averageByDate(this.createSeriesPerBuild(configuration, resultAction.getResult()));
            averagesPerJob.put(resultAction, averageByDate);
            availableDates.addAll(averageByDate.keySet());
        }
        JFreeChart chart = this.createChart(this.createDatasetPerDay(this.createTotalsForAllAvailableDates(resultActions, availableDates, averagesPerJob)));
        this.attachRenderers(configuration, pluginName, chart, resultActions.iterator().next().getToolTipProvider());
        return chart;
    }

    private Map<LocalDate, List<Integer>> createTotalsForAllAvailableDates(Collection<ResultAction<? extends BuildResult>> jobs, Set<LocalDate> availableDates, Map<ResultAction<? extends BuildResult>, Map<LocalDate, List<Integer>>> averagesPerJob) {
        ArrayList sortedDates = Lists.newArrayList(availableDates);
        Collections.sort(sortedDates);
        HashMap totals = Maps.newHashMap();
        for (ResultAction<? extends BuildResult> jobResult : jobs) {
            Map<LocalDate, List<Integer>> availableResults = averagesPerJob.get(jobResult);
            List<Integer> lastResult = Collections.emptyList();
            for (LocalDate buildDate : sortedDates) {
                if (availableResults.containsKey(buildDate)) {
                    List<Integer> additionalResult = availableResults.get(buildDate);
                    this.addValues(buildDate, totals, additionalResult);
                    lastResult = additionalResult;
                    continue;
                }
                if (lastResult.isEmpty()) continue;
                this.addValues(buildDate, totals, lastResult);
            }
        }
        return totals;
    }

    private void addValues(LocalDate buildDate, Map<LocalDate, List<Integer>> totals, List<Integer> additionalResult) {
        if (totals.containsKey(buildDate)) {
            List<Integer> existingResult = totals.get(buildDate);
            ArrayList sum = Lists.newArrayList();
            for (int i = 0; i < existingResult.size(); ++i) {
                sum.add(existingResult.get(i) + additionalResult.get(i));
            }
            totals.put(buildDate, sum);
        } else {
            totals.put(buildDate, additionalResult);
        }
    }

    private void attachRenderers(GraphConfiguration configuration, String pluginName, JFreeChart chart, ToolTipProvider toolTipProvider) {
        CategoryItemRenderer renderer = this.createRenderer(configuration, pluginName, toolTipProvider);
        CategoryPlot plot = chart.getCategoryPlot();
        plot.setRenderer(renderer);
        this.setColors(chart, this.getColors());
    }

    protected JFreeChart createChart(GraphConfiguration configuration, ResultAction<? extends BuildResult> action) {
        CategoryDataset dataSet;
        if (configuration.useBuildDateAsDomain()) {
            Map<LocalDate, List<Integer>> averagePerDay = this.averageByDate(this.createSeriesPerBuild(configuration, action.getResult()));
            dataSet = this.createDatasetPerDay(averagePerDay);
        } else {
            dataSet = this.createDatasetPerBuildNumber(this.createSeriesPerBuild(configuration, action.getResult()));
        }
        return this.createChart(dataSet);
    }

    private Map<Run, List<Integer>> createSeriesPerBuild(GraphConfiguration configuration, BuildResult lastBuildResult) {
        BuildResult current = lastBuildResult;
        int buildCount = 0;
        HashMap valuesPerBuild = Maps.newHashMap();
        String parameterName = configuration.getParameterName();
        String parameterValue = configuration.getParameterValue();
        while (!this.isBuildTooOld(configuration, current)) {
            if (this.passesFilteringByParameter(current.getOwner(), parameterName, parameterValue)) {
                valuesPerBuild.put(current.getOwner(), this.computeSeries(current));
            }
            if (current.hasPreviousResult() && (current = current.getPreviousResult()) != null && (!configuration.isBuildCountDefined() || ++buildCount < configuration.getBuildCount())) continue;
            break;
        }
        return valuesPerBuild;
    }

    private CategoryDataset createDatasetPerBuildNumber(Map<Run, List<Integer>> valuesPerBuild) {
        DataSetBuilder builder = new DataSetBuilder();
        ArrayList builds = Lists.newArrayList(valuesPerBuild.keySet());
        Collections.sort(builds);
        for (Run build : builds) {
            List<Integer> series = valuesPerBuild.get(build);
            int level = 0;
            for (Integer integer : series) {
                builder.add((Number)integer, (Comparable)((Object)this.getRowId(level)), (Comparable)new ChartUtil.NumberOnlyBuildLabel(build));
                ++level;
            }
        }
        return builder.build();
    }

    private CategoryDataset createDatasetPerDay(Map<LocalDate, List<Integer>> averagePerDay) {
        ArrayList buildDates = Lists.newArrayList(averagePerDay.keySet());
        Collections.sort(buildDates);
        DataSetBuilder builder = new DataSetBuilder();
        for (LocalDate date : buildDates) {
            int level = 0;
            for (Integer average : averagePerDay.get(date)) {
                builder.add((Number)average, (Comparable)((Object)this.getRowId(level)), (Comparable)new LocalDateLabel(date));
                ++level;
            }
        }
        return builder.build();
    }

    private Map<LocalDate, List<Integer>> averageByDate(Map<Run, List<Integer>> valuesPerBuild) {
        return this.createSeriesPerDay(this.createMultiSeriesPerDay(valuesPerBuild));
    }

    private Map<LocalDate, List<Integer>> createSeriesPerDay(Multimap<LocalDate, List<Integer>> multiSeriesPerDate) {
        HashMap seriesPerDate = Maps.newHashMap();
        for (LocalDate date : multiSeriesPerDate.keySet()) {
            Iterator perDayIterator = multiSeriesPerDate.get((Object)date).iterator();
            List total = (List)perDayIterator.next();
            int seriesCount = 1;
            while (perDayIterator.hasNext()) {
                List additional = (List)perDayIterator.next();
                ++seriesCount;
                ArrayList sum = Lists.newArrayList();
                for (int i = 0; i < total.size(); ++i) {
                    sum.add((Integer)total.get(i) + (Integer)additional.get(i));
                }
                total = sum;
            }
            ArrayList series = Lists.newArrayList();
            for (Integer totalValue : total) {
                series.add(totalValue / seriesCount);
            }
            seriesPerDate.put(date, series);
        }
        return seriesPerDate;
    }

    @SuppressFBWarnings(value={"WMI"})
    private Multimap<LocalDate, List<Integer>> createMultiSeriesPerDay(Map<Run, List<Integer>> valuesPerBuild) {
        HashMultimap valuesPerDate = HashMultimap.create();
        for (Run build : valuesPerBuild.keySet()) {
            valuesPerDate.put((Object)new LocalDate((Object)build.getTimestamp()), valuesPerBuild.get(build));
        }
        return valuesPerDate;
    }

    protected String getRowId(int level) {
        return String.valueOf(level);
    }

    protected abstract List<Integer> computeSeries(BuildResult var1);

    protected abstract JFreeChart createChart(CategoryDataset var1);

    protected abstract CategoryItemRenderer createRenderer(GraphConfiguration var1, String var2, ToolTipProvider var3);

    protected abstract Color[] getColors();

    public JFreeChart createAreaChart(CategoryDataset dataset) {
        return this.createAreaChart(dataset, "count");
    }

    public JFreeChart createAreaChart(CategoryDataset dataset, String yAxisLabel) {
        JFreeChart chart = ChartFactory.createStackedAreaChart(null, null, (String)yAxisLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        this.setCategoryPlotProperties(chart.getCategoryPlot());
        chart.getCategoryPlot().getDomainAxis().setCategoryMargin(0.0);
        return chart;
    }

    protected CategoryItemRenderer createLineRenderer() {
        LineAndShapeRenderer render = new LineAndShapeRenderer(true, false);
        render.setBaseStroke((Stroke)new BasicStroke(2.0f));
        return render;
    }

    protected JFreeChart createLineGraph(CategoryDataset dataSet, boolean hasLegend) {
        return this.createLineGraph(dataSet, hasLegend, Y_AXIS_LABEL);
    }

    protected JFreeChart createLineGraph(CategoryDataset dataSet, boolean hasLegend, String yAxisLabel) {
        NumberAxis numberAxis = new NumberAxis(yAxisLabel);
        numberAxis.setAutoRange(true);
        numberAxis.setAutoRangeIncludesZero(false);
        CategoryAxis domainAxis = new CategoryAxis();
        domainAxis.setCategoryMargin(0.0);
        CategoryPlot plot = new CategoryPlot(dataSet, domainAxis, (ValueAxis)numberAxis, (CategoryItemRenderer)new LineAndShapeRenderer(true, false));
        plot.setOrientation(PlotOrientation.VERTICAL);
        JFreeChart chart = new JFreeChart(null, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, hasLegend);
        if (hasLegend) {
            chart.getLegend().setItemFont(LEGEND_FONT);
        }
        chart.setBackgroundPaint((Paint)Color.white);
        this.setCategoryPlotProperties(plot);
        return chart;
    }
}

