/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.graph.GraphConfigurationView;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class DefaultGraphConfigurationView
extends GraphConfigurationView {
    private final String url;

    public DefaultGraphConfigurationView(GraphConfiguration configuration, Job<?, ?> job, String pluginName, BuildHistory buildHistory, String url) {
        super(configuration, job, pluginName, buildHistory);
        this.url = url;
        configuration.initializeFromFile(DefaultGraphConfigurationView.createDefaultsFile(job, pluginName));
    }

    @Deprecated
    public DefaultGraphConfigurationView(GraphConfiguration configuration, AbstractProject<?, ?> project, String pluginName, BuildHistory buildHistory, String url) {
        this(configuration, (Job<?, ?>)project, pluginName, buildHistory, url);
    }

    public DefaultGraphConfigurationView(GraphConfiguration configuration, Job<?, ?> job, String pluginName, BuildHistory buildHistory) {
        this(configuration, job, pluginName, buildHistory, job.getAbsoluteUrl() + pluginName + "/configureDefaults");
    }

    @Deprecated
    public DefaultGraphConfigurationView(GraphConfiguration configuration, AbstractProject<?, ?> project, String pluginName, BuildHistory buildHistory) {
        this(configuration, (Job<?, ?>)project, pluginName, buildHistory, project.getAbsoluteUrl() + pluginName + "/configureDefaults");
    }

    public String getDisplayName() {
        return Messages.DefaultGraphConfiguration_Name();
    }

    @Override
    public String getDescription() {
        return Messages.DefaultGraphConfiguration_Description();
    }

    public String getUrl() {
        return this.url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void persistValue(String value, String pluginName, StaplerRequest request, StaplerResponse response) throws FileNotFoundException, IOException {
        try (FileOutputStream output = new FileOutputStream(DefaultGraphConfigurationView.createDefaultsFile(this.getOwner(), pluginName));){
            IOUtils.write((String)value, (OutputStream)output);
        }
    }
}

