/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.core.ResultAction;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.CategoryUrlBuilder;
import hudson.plugins.analysis.util.Pair;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DifferenceGraph
extends BuildResultGraph {
    @Override
    public String getId() {
        return "DIFFERENCE";
    }

    @Override
    public String getLabel() {
        return Messages.Trend_type_difference();
    }

    @Override
    public JFreeChart create(GraphConfiguration configuration, ResultAction<? extends BuildResult> resultAction, String pluginName) {
        ArrayList<Pair<Integer, Integer>> fixedWarnings = new ArrayList<Pair<Integer, Integer>>();
        ArrayList<Pair<Integer, Integer>> newWarnings = new ArrayList<Pair<Integer, Integer>>();
        this.extractPoints(configuration, resultAction, fixedWarnings, newWarnings);
        XYSeriesCollection xySeriesCollection = this.computeDifferenceSeries(fixedWarnings, newWarnings);
        JFreeChart chart = this.createXYChart((XYDataset)xySeriesCollection);
        chart.getXYPlot().getRenderer().setURLGenerator((XYURLGenerator)new XyUrlBuilder(this.getRootUrl(), pluginName));
        NumberAxis axis = new NumberAxis();
        axis.setVerticalTickLabels(true);
        axis.setNumberFormatOverride((NumberFormat)new HudsonBuildFormat());
        axis.setAutoRange(true);
        axis.setAutoRangeIncludesZero(false);
        axis.setLowerMargin(0.0);
        axis.setUpperMargin(0.0);
        axis.setTickUnit(new NumberTickUnit(1.0));
        chart.getXYPlot().setDomainAxis((ValueAxis)axis);
        return chart;
    }

    @Override
    public JFreeChart createAggregation(GraphConfiguration configuration, Collection<ResultAction<? extends BuildResult>> resultActions, String pluginName) {
        return this.create(configuration, resultActions.iterator().next(), pluginName);
    }

    private XYSeriesCollection computeDifferenceSeries(List<Pair<Integer, Integer>> fixedWarnings, List<Pair<Integer, Integer>> newWarnings) {
        XYSeries fixedSeries = new XYSeries((Comparable)((Object)"fixed"));
        XYSeries newSeries = new XYSeries((Comparable)((Object)"new"));
        int fixedCount = 0;
        int newCount = 0;
        for (int i = 0; i < fixedWarnings.size(); ++i) {
            Pair<Integer, Integer> point = fixedWarnings.get(i);
            int build = point.getHead();
            fixedCount += point.getTail().intValue();
            point = newWarnings.get(i);
            fixedSeries.add((double)build, (double)fixedCount);
            newSeries.add((double)build, (double)(newCount += point.getTail().intValue()));
        }
        XYSeriesCollection xySeriesCollection = new XYSeriesCollection();
        xySeriesCollection.addSeries(fixedSeries);
        xySeriesCollection.addSeries(newSeries);
        return xySeriesCollection;
    }

    private void extractPoints(GraphConfiguration configuration, ResultAction<? extends BuildResult> action, List<Pair<Integer, Integer>> fixedWarnings, List<Pair<Integer, Integer>> newWarnings) {
        int buildCount = 0;
        BuildResult current = action.getResult();
        while (!this.isBuildTooOld(configuration, current)) {
            int build = current.getOwner().getNumber();
            fixedWarnings.add(new Pair<Integer, Integer>(build, current.getNumberOfFixedWarnings()));
            newWarnings.add(new Pair<Integer, Integer>(build, current.getNumberOfNewWarnings()));
            if (!current.hasPreviousResult()) break;
            current = current.getPreviousResult();
            if (!configuration.isBuildCountDefined() || ++buildCount < configuration.getBuildCount()) continue;
            break;
        }
        Collections.reverse(fixedWarnings);
        Collections.reverse(newWarnings);
    }

    private static class XyUrlBuilder
    extends CategoryUrlBuilder
    implements XYURLGenerator {
        private static final long serialVersionUID = 7555399727715726510L;

        public XyUrlBuilder(String rootUrl, String pluginName) {
            super(rootUrl, pluginName);
        }

        public String generateURL(XYDataset dataset, int series, int item) {
            return this.getRootUrl() + (int)dataset.getXValue(series, item) + this.getPluginName();
        }
    }

    private static final class HudsonBuildFormat
    extends NumberFormat {
        private static final long serialVersionUID = 3487003853901042584L;

        private HudsonBuildFormat() {
        }

        @Override
        public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
            return this.format((long)number, toAppendTo, pos);
        }

        @Override
        public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('#');
            stringBuffer.append(number);
            return stringBuffer;
        }

        @Override
        public Number parse(String source, ParsePosition parsePosition) {
            return null;
        }
    }
}

