/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import hudson.model.AbstractProject;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.NullGraph;
import hudson.plugins.analysis.graph.PriorityGraph;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class GraphConfiguration {
    private static final int MAXIMUM_SIZE = 2000;
    private static final int MINIMUM_SIZE = 25;
    private static final boolean DEFAULT_USE_BUILD_DATE = false;
    private static final int DEFAULT_BUILD_COUNT = 50;
    private static final int DEFAULT_DAY_COUNT = 30;
    private static final int DEFAULT_WIDTH = 500;
    private static final int DEFAULT_HEIGHT = 200;
    private static final String DEFAULT_NAME = "";
    private static final String DEFAULT_VALUE = "";
    protected static final String SEPARATOR = "!";
    private int height;
    private int width;
    private BuildResultGraph graphType;
    private int buildCount;
    private int dayCount;
    private boolean useBuildDate;
    private String parameterName;
    private String parameterValue;
    private final Map<String, BuildResultGraph> graphId2Graph = Maps.newHashMap();
    private final List<BuildResultGraph> availableGraphs;

    private static PriorityGraph createDefaultGraph() {
        return new PriorityGraph();
    }

    public static GraphConfiguration createDeactivated() {
        return new GraphConfiguration((BuildResultGraph)new NullGraph());
    }

    public static GraphConfiguration createDefault() {
        return new GraphConfiguration((BuildResultGraph)GraphConfiguration.createDefaultGraph());
    }

    public GraphConfiguration(Collection<? extends BuildResultGraph> availableGraphs) {
        this.availableGraphs = ImmutableList.copyOf(availableGraphs);
        for (BuildResultGraph buildResultGraph : availableGraphs) {
            this.graphId2Graph.put(buildResultGraph.getId(), buildResultGraph);
        }
    }

    public GraphConfiguration(BuildResultGraph ... availableGraphs) {
        this(Arrays.asList(availableGraphs));
    }

    public GraphConfiguration(BuildResultGraph graph) {
        this.reset();
        this.availableGraphs = Lists.newArrayList();
        this.graphType = graph;
        this.availableGraphs.add(this.graphType);
    }

    public boolean initializeFrom(String value) {
        return this.resetIfInvalid(this.initializeFromStringValue(value));
    }

    public boolean initializeFrom(int width, int height) {
        return this.initializeFrom(width, height, 0);
    }

    public boolean initializeFrom(int width, int height, int dayCount) {
        return this.initializeFrom(width, height, dayCount, "", "");
    }

    public boolean initializeFrom(int width, int height, int dayCount, String parameterName, String parameterValue) {
        this.width = width;
        this.height = height;
        this.dayCount = dayCount;
        this.buildCount = 0;
        this.useBuildDate = true;
        this.parameterName = parameterName;
        this.parameterValue = parameterValue;
        return this.resetIfInvalid(GraphConfiguration.isValid(width, height, this.buildCount, dayCount, this.graphType, parameterName, parameterValue));
    }

    public boolean initializeFrom(String width, String height, String dayCountString) {
        return this.initializeFrom(width, height, dayCountString, "", "");
    }

    public boolean initializeFrom(String width, String height, String dayCountString, String parameterName, String parameterValue) {
        try {
            this.dayCount = StringUtils.isBlank((String)dayCountString) ? 0 : Integer.parseInt(dayCountString);
            return this.initializeFrom(Integer.parseInt(width), Integer.parseInt(height), this.dayCount, parameterName, parameterValue);
        }
        catch (NumberFormatException exception) {
            this.reset();
            return false;
        }
    }

    private boolean resetIfInvalid(boolean isSuccessful) {
        if (!isSuccessful) {
            this.reset();
        }
        return isSuccessful;
    }

    private boolean initializeFromStringValue(String value) {
        if (StringUtils.isBlank((String)value)) {
            return false;
        }
        String[] values = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)value, (String)SEPARATOR);
        if (values.length < 6) {
            return false;
        }
        try {
            this.width = Integer.parseInt(values[0]);
            this.height = Integer.parseInt(values[1]);
            this.buildCount = Integer.parseInt(values[2]);
            this.dayCount = Integer.parseInt(values[3]);
            this.graphType = this.graphId2Graph.get(values[4]);
            if ("0".equals(values[5])) {
                this.useBuildDate = false;
            } else if ("1".equals(values[5])) {
                this.useBuildDate = true;
            } else {
                return false;
            }
            if (values.length > 7) {
                this.parameterName = values[6];
                this.parameterValue = values[7];
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        catch (IllegalArgumentException exception) {
            return false;
        }
        String[] localConfiguration = new String[values.length - 6];
        System.arraycopy(values, 6, localConfiguration, 0, values.length - 6);
        boolean isLocalValid = this.initializeLocal(localConfiguration);
        return isLocalValid && GraphConfiguration.isValid(this.width, this.height, this.buildCount, this.dayCount, this.graphType, this.parameterName, this.parameterValue);
    }

    protected boolean initializeLocal(String[] localConfiguration) {
        return true;
    }

    public boolean initializeFrom(JSONObject value) {
        return this.resetIfInvalid(this.initializeFromJsonObject(value));
    }

    private boolean initializeFromJsonObject(JSONObject value) {
        this.width = value.getInt("width");
        this.height = value.getInt("height");
        String buildCountString = value.getString("buildCountString");
        this.buildCount = 0;
        if (StringUtils.isNotBlank((String)buildCountString)) {
            this.buildCount = value.getInt("buildCountString");
        }
        String dayCountString = value.getString("dayCountString");
        this.dayCount = 0;
        if (StringUtils.isNotBlank((String)dayCountString)) {
            this.dayCount = value.getInt("dayCountString");
        }
        String graphTypeString = value.getString("graphType");
        this.graphType = this.graphId2Graph.get(graphTypeString);
        this.useBuildDate = value.getBoolean("useBuildDateAsDomain");
        this.parameterName = value.has("parameterName") ? value.getString("parameterName") : "";
        this.parameterValue = value.has("parameterValue") ? value.getString("parameterValue") : "";
        boolean isLocalValid = this.initializeLocal(value);
        return isLocalValid && GraphConfiguration.isValid(this.width, this.height, this.buildCount, this.dayCount, this.graphType, this.parameterName, this.parameterValue);
    }

    protected boolean initializeLocal(JSONObject localConfiguration) {
        return true;
    }

    public boolean initializeFromFile(File file) {
        return this.initializeFrom(this.readFromDefaultsFile(file));
    }

    protected File createDefaultsFile(AbstractProject<?, ?> project, String pluginName) {
        return new File(project.getRootDir(), pluginName + ".txt");
    }

    public String getBuildCountString() {
        if (this.isBuildCountDefined()) {
            return String.valueOf(this.getBuildCount());
        }
        return "";
    }

    public String getDayCountString() {
        if (this.isDayCountDefined()) {
            return String.valueOf(this.getDayCount());
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String readFromDefaultsFile(File defaultsFile) {
        String defaultValue = "";
        FileInputStream input = null;
        try {
            input = new FileInputStream(defaultsFile);
            defaultValue = IOUtils.toString((InputStream)input);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly((InputStream)input);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(input);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)input);
        return defaultValue;
    }

    private void reset() {
        this.height = 200;
        this.width = 500;
        this.buildCount = 50;
        this.dayCount = 30;
        this.graphType = GraphConfiguration.createDefaultGraph();
        this.useBuildDate = false;
        this.parameterName = "";
        this.parameterValue = "";
    }

    public String serializeToString() {
        return this.width + SEPARATOR + this.height + SEPARATOR + this.buildCount + SEPARATOR + this.dayCount + SEPARATOR + this.graphType.getId() + SEPARATOR + this.serializeBoolean(this.useBuildDate) + SEPARATOR + this.parameterName + SEPARATOR + this.parameterValue + SEPARATOR;
    }

    protected String serializeBoolean(boolean value) {
        if (value) {
            return "1";
        }
        return "0";
    }

    protected static boolean isValid(int newWidth, int newHeight, int newBuildCount, int newDayCount, BuildResultGraph newGraphType, String newParameterName, String newParameterValue) {
        return GraphConfiguration.isValidWidth(newWidth) && GraphConfiguration.isValidHeight(newHeight) && newGraphType != null && newDayCount >= 0 && GraphConfiguration.isValidBuildCount(newBuildCount) && !(StringUtils.isNotBlank((String)newParameterName) ^ StringUtils.isNotBlank((String)newParameterValue));
    }

    protected static boolean isValidBuildCount(int newBuildCount) {
        return newBuildCount == 0 || newBuildCount > 1;
    }

    protected static boolean isValidWidth(int newWidth) {
        return newWidth > 25 && newWidth < 2000;
    }

    protected static boolean isValidHeight(int newHeight) {
        return newHeight > 25 && newHeight < 2000;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean useBuildDateAsDomain() {
        return this.useBuildDate;
    }

    public int getBuildCount() {
        return this.buildCount;
    }

    public boolean isBuildCountDefined() {
        return this.buildCount > 1;
    }

    public int getDayCount() {
        return this.dayCount;
    }

    public boolean isDayCountDefined() {
        return this.dayCount > 0;
    }

    public BuildResultGraph getGraphType() {
        return this.graphType;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public String getParameterValue() {
        return this.parameterValue;
    }

    public boolean isDefault() {
        return this.width == 500 && this.height == 200 && this.graphType.getId() == GraphConfiguration.createDefaultGraph().getId() && this.buildCount == 50 && this.dayCount == 30 && !this.useBuildDate && this.parameterName == "" && this.parameterValue == "";
    }

    public boolean isVisible() {
        return this.graphType.isVisible();
    }

    public String toString() {
        return "type: " + this.graphType + ", size: " + this.width + "x" + this.height + ", # builds " + this.buildCount + ", # days " + this.dayCount + ", useBuildDate:" + this.useBuildDate + ", parameterName:" + this.parameterName + ", parameterValue:" + this.parameterValue;
    }

    public Collection<BuildResultGraph> getRegisteredGraphs() {
        return this.availableGraphs;
    }

    public BuildResultGraph getGraph(String graphId) {
        if (this.graphId2Graph.containsKey(graphId)) {
            return this.graphId2Graph.get(graphId);
        }
        return GraphConfiguration.createDefaultGraph();
    }

    public static FormValidation checkHeight(String height) {
        try {
            if (GraphConfiguration.isValidHeight(Integer.valueOf(height))) {
                return FormValidation.ok();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return FormValidation.error((String)("Invalid height value: " + height));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = prime * result + this.buildCount;
        result = prime * result + this.dayCount;
        result = prime * result + (this.graphType == null ? 0 : this.graphType.getId().hashCode());
        result = prime * result + this.height;
        result = prime * result + (this.useBuildDate ? 1231 : 1237);
        result = prime * result + this.width;
        result = prime * result + this.parameterName.hashCode();
        result = prime * result + this.parameterValue.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GraphConfiguration other = (GraphConfiguration)obj;
        if (this.buildCount != other.buildCount) {
            return false;
        }
        if (this.dayCount != other.dayCount) {
            return false;
        }
        if (this.graphType == null ? other.graphType != null : !this.graphType.getId().equals(other.graphType.getId())) {
            return false;
        }
        if (this.height != other.height) {
            return false;
        }
        if (this.useBuildDate != other.useBuildDate) {
            return false;
        }
        if (this.width != other.width) {
            return false;
        }
        if (this.parameterName == null ? other.parameterName != null : !this.parameterName.equals(other.parameterName)) {
            return false;
        }
        return !(this.parameterValue == null ? other.parameterValue != null : !this.parameterValue.equals(other.parameterValue));
    }
}

