/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import com.google.common.collect.Lists;
import com.infradna.tool.bridge_method_injector.BridgeMethodsAdded;
import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.ModelObject;
import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.graph.BuildResultGraph;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.util.Graph;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

@BridgeMethodsAdded
public abstract class GraphConfigurationView
implements ModelObject {
    private static final Logger LOGGER = Logger.getLogger(GraphConfigurationView.class.getName());
    private final Job<?, ?> owner;
    private final String key;
    private final BuildHistory buildHistory;
    private final AbstractHealthDescriptor healthDescriptor;
    private final GraphConfiguration configuration;
    private String urlPrefix;

    public GraphConfigurationView(GraphConfiguration configuration, Job<?, ?> job, String key, BuildHistory buildHistory) {
        this.configuration = configuration;
        this.owner = job;
        this.key = key;
        this.buildHistory = buildHistory;
        this.healthDescriptor = buildHistory.getHealthDescriptor();
    }

    @Deprecated
    public GraphConfigurationView(GraphConfiguration configuration, AbstractProject<?, ?> project, String key, BuildHistory buildHistory) {
        this(configuration, (Job<?, ?>)project, key, buildHistory);
    }

    protected static File createDefaultsFile(Job<?, ?> job, String pluginName) {
        return new File(job.getRootDir(), pluginName + ".txt");
    }

    @Deprecated
    protected static File createDefaultsFile(AbstractProject<?, ?> project, String pluginName) {
        return GraphConfigurationView.createDefaultsFile(project, pluginName);
    }

    public List<? extends BuildResultGraph> getAvailableGraphs() {
        ArrayList selectable = Lists.newArrayList();
        for (BuildResultGraph graph : this.configuration.getRegisteredGraphs()) {
            if (!graph.isSelectable()) continue;
            selectable.add(graph);
        }
        return selectable;
    }

    @WithBridgeMethods(value={AbstractProject.class}, adapterMethod="getAbstractProject")
    public Job<?, ?> getOwner() {
        return this.owner;
    }

    @Deprecated
    private Object getAbstractProject(Job owner, Class targetClass) {
        return owner instanceof AbstractProject ? (AbstractProject)owner : null;
    }

    public String getKey() {
        return this.key;
    }

    public abstract String getDescription();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(StaplerRequest request, StaplerResponse response) {
        try {
            JSONObject formData = request.getSubmittedForm();
            if (this.configuration.initializeFrom(formData)) {
                this.persistValue(this.configuration.serializeToString(), this.key, request, response);
            }
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Can't save the form data: " + request, exception);
        }
        catch (ServletException exception) {
            LOGGER.log(Level.SEVERE, "Can't process the form data: " + request, exception);
        }
        finally {
            try {
                response.sendRedirect(this.owner.getAbsoluteUrl());
            }
            catch (IOException exception) {
                LOGGER.log(Level.SEVERE, "Can't redirect", exception);
            }
        }
    }

    public boolean hasMeaningfulGraph() {
        if (this.buildHistory.hasPreviousResult()) {
            return !BuildResultGraph.areResultsTooOld(this.configuration, this.buildHistory.getPreviousResult());
        }
        return false;
    }

    protected abstract void persistValue(String var1, String var2, StaplerRequest var3, StaplerResponse var4) throws IOException;

    public Object getDynamic(String graphId, StaplerRequest request, StaplerResponse response) {
        try {
            BuildResultGraph graph = this.configuration.getGraph(graphId);
            if (this.hasMeaningfulGraph() && graph.isVisible()) {
                return graph.getGraph(-1L, this.configuration, null, this.buildHistory.getBaseline());
            }
            response.sendRedirect2(request.getContextPath() + graph.getExampleImage());
        }
        catch (IOException exception) {
            LOGGER.log(Level.SEVERE, "Can't create graph: " + request, exception);
        }
        return null;
    }

    public Graph getGraphRenderer(BuildResultGraph graph, String url) {
        return graph.getGraph(this.getTimestamp(), this.configuration, url, this.buildHistory.getBaseline());
    }

    public Graph getGraphRenderer() {
        return this.getGraphRenderer(this.getGraphType(), null);
    }

    public Graph getGraphRenderer(String url) {
        return this.getGraphRenderer(this.getGraphType(), url);
    }

    public boolean isHealthGraphAvailable() {
        return this.healthDescriptor.isEnabled();
    }

    public int getHeight() {
        return this.configuration.getHeight();
    }

    public int getWidth() {
        return this.configuration.getWidth();
    }

    public boolean getUseBuildDateAsDomain() {
        return this.configuration.useBuildDateAsDomain();
    }

    public long getTimestamp() {
        return this.buildHistory.getTimestamp().getTimeInMillis();
    }

    public int getBuildCount() {
        return this.configuration.getBuildCount();
    }

    public String getBuildCountString() {
        return this.getStringValue(this.getBuildCount());
    }

    private String getStringValue(int value) {
        return value == 0 ? "" : String.valueOf(value);
    }

    public int getDayCount() {
        return this.configuration.getDayCount();
    }

    public String getDayCountString() {
        return this.getStringValue(this.getDayCount());
    }

    public String getParameterName() {
        return this.configuration.getParameterName();
    }

    public String getParameterValue() {
        return this.configuration.getParameterValue();
    }

    public BuildResultGraph getGraphType() {
        BuildResultGraph graphType = this.configuration.getGraphType();
        graphType.setRootUrl(StringUtils.defaultString((String)this.urlPrefix));
        return graphType;
    }

    public boolean isVisible() {
        return this.getGraphType().isVisible();
    }

    public boolean isDeactivated() {
        return this.getGraphType().isDeactivated();
    }

    public String toString() {
        return this.configuration.toString();
    }

    public AbstractHealthDescriptor getHealthDescriptor() {
        return this.healthDescriptor;
    }

    public void setUrlPrefix(String urlPrefix) {
        this.urlPrefix = urlPrefix;
    }
}

