/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.AbstractHealthDescriptor;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.graph.CategoryBuildResultGraph;
import hudson.plugins.analysis.graph.ColorPalette;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.AreaRenderer;
import hudson.plugins.analysis.util.CategoryUrlBuilder;
import hudson.plugins.analysis.util.SerializableToolTipGenerator;
import hudson.plugins.analysis.util.ToolTipAreaRenderer;
import hudson.plugins.analysis.util.ToolTipProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

public class HealthGraph
extends CategoryBuildResultGraph {
    private final AbstractHealthDescriptor healthDescriptor;

    public HealthGraph(AbstractHealthDescriptor healthDescriptor) {
        this.healthDescriptor = healthDescriptor;
    }

    @Override
    public boolean isSelectable() {
        return this.healthDescriptor.isEnabled();
    }

    @Override
    public String getId() {
        return "HEALTH";
    }

    @Override
    public String getLabel() {
        return Messages.Trend_type_health();
    }

    @Override
    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        int remainder = current.getNumberOfAnnotations();
        if (this.healthDescriptor.isHealthyReportEnabled()) {
            series.add(Math.min(remainder, this.healthDescriptor.getHealthyAnnotations()));
            int range = this.healthDescriptor.getUnHealthyAnnotations() - this.healthDescriptor.getHealthyAnnotations();
            if ((remainder -= this.healthDescriptor.getHealthyAnnotations()) > 0) {
                series.add(Math.min(remainder, range));
            } else {
                series.add(0);
            }
            if ((remainder -= range) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        } else if (this.healthDescriptor.isThresholdEnabled()) {
            series.add(Math.min(remainder, this.healthDescriptor.getLowerBoundOfThresholds()));
            if ((remainder -= this.healthDescriptor.getLowerBoundOfThresholds()) > 0) {
                series.add(remainder);
            } else {
                series.add(0);
            }
        } else {
            series.add(remainder);
        }
        return series;
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createAreaChart(dataSet);
    }

    private boolean useThreeColors() {
        return this.healthDescriptor.isHealthyReportEnabled() || !this.healthDescriptor.isThresholdEnabled();
    }

    @Override
    @SuppressFBWarnings(value={"SIC"})
    protected CategoryItemRenderer createRenderer(GraphConfiguration configuration, String pluginName, final ToolTipProvider toolTipProvider) {
        CategoryUrlBuilder urlGenerator = new CategoryUrlBuilder(this.getRootUrl(), pluginName);
        SerializableToolTipGenerator toolTipGenerator = new SerializableToolTipGenerator(){

            public String generateToolTip(CategoryDataset dataset, int row, int column) {
                int number = 0;
                for (int index = 0; index < dataset.getRowCount(); ++index) {
                    Number value = dataset.getValue(index, column);
                    if (value == null) continue;
                    number += value.intValue();
                }
                return toolTipProvider.getTooltip(number);
            }
        };
        if (configuration.useBuildDateAsDomain()) {
            return new ToolTipAreaRenderer(toolTipGenerator);
        }
        return new AreaRenderer(urlGenerator, toolTipGenerator);
    }

    @Override
    protected Color[] getColors() {
        if (this.useThreeColors()) {
            return new Color[]{ColorPalette.BLUE, ColorPalette.YELLOW, ColorPalette.RED};
        }
        return new Color[]{ColorPalette.BLUE, ColorPalette.RED};
    }
}

