/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.graph.CategoryBuildResultGraph;
import hudson.plugins.analysis.graph.ColorPalette;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.BoxRenderer;
import hudson.plugins.analysis.util.CategoryUrlBuilder;
import hudson.plugins.analysis.util.ToolTipBoxRenderer;
import hudson.plugins.analysis.util.ToolTipBuilder;
import hudson.plugins.analysis.util.ToolTipProvider;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

public class NewVersusFixedGraph
extends CategoryBuildResultGraph {
    @Override
    public String getId() {
        return "FIXED";
    }

    @Override
    public String getLabel() {
        return Messages.Trend_type_fixed();
    }

    @Override
    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        series.add(current.getNumberOfNewWarnings());
        series.add(current.getNumberOfFixedWarnings());
        return series;
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createBlockChart(dataSet);
    }

    @Override
    protected Color[] getColors() {
        return new Color[]{ColorPalette.RED, ColorPalette.BLUE};
    }

    @Override
    protected CategoryItemRenderer createRenderer(GraphConfiguration configuration, String pluginName, ToolTipProvider toolTipProvider) {
        UrlBuilder url = new UrlBuilder(this.getRootUrl(), pluginName);
        DescriptionBuilder toolTip = new DescriptionBuilder(toolTipProvider);
        if (configuration.useBuildDateAsDomain()) {
            return new ToolTipBoxRenderer(toolTip);
        }
        return new BoxRenderer(url, toolTip);
    }

    private static final class DescriptionBuilder
    extends ToolTipBuilder {
        private static final long serialVersionUID = 2680597046798379462L;

        DescriptionBuilder(ToolTipProvider provider) {
            super(provider);
        }

        @Override
        protected String getShortDescription(int row) {
            if (row == 1) {
                return Messages.Trend_Fixed();
            }
            return Messages.Trend_New();
        }
    }

    private static final class UrlBuilder
    extends CategoryUrlBuilder {
        private static final long serialVersionUID = -513005297527489127L;

        UrlBuilder(String rootUrl, String pluginName) {
            super(rootUrl, pluginName);
        }

        @Override
        protected String getDetailUrl(int row) {
            if (row == 1) {
                return "fixed";
            }
            return "new";
        }
    }
}

