/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildResult;
import hudson.plugins.analysis.graph.CategoryBuildResultGraph;
import hudson.plugins.analysis.graph.ColorPalette;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.util.AreaRenderer;
import hudson.plugins.analysis.util.CategoryUrlBuilder;
import hudson.plugins.analysis.util.ToolTipAreaRenderer;
import hudson.plugins.analysis.util.ToolTipBuilder;
import hudson.plugins.analysis.util.ToolTipProvider;
import hudson.plugins.analysis.util.model.Priority;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;

public class PriorityGraph
extends CategoryBuildResultGraph {
    @Override
    public String getId() {
        return "PRIORITY";
    }

    @Override
    public String getLabel() {
        return Messages.Trend_type_priority();
    }

    @Override
    protected List<Integer> computeSeries(BuildResult current) {
        ArrayList<Integer> series = new ArrayList<Integer>();
        series.add(current.getNumberOfAnnotations(Priority.LOW));
        series.add(current.getNumberOfAnnotations(Priority.NORMAL));
        series.add(current.getNumberOfAnnotations(Priority.HIGH));
        return series;
    }

    @Override
    protected JFreeChart createChart(CategoryDataset dataSet) {
        return this.createAreaChart(dataSet);
    }

    @Override
    protected Color[] getColors() {
        return new Color[]{ColorPalette.BLUE, ColorPalette.YELLOW, ColorPalette.RED};
    }

    @Override
    @SuppressFBWarnings(value={"SIC"})
    protected CategoryItemRenderer createRenderer(GraphConfiguration configuration, String pluginName, ToolTipProvider toolTipProvider) {
        UrlBuilder url = new UrlBuilder(this.getRootUrl(), pluginName);
        ToolTipBuilder toolTip = new ToolTipBuilder(toolTipProvider){

            @Override
            protected String getShortDescription(int row) {
                if (row == 0) {
                    return Messages.Trend_PriorityLow();
                }
                if (row == 1) {
                    return Messages.Trend_PriorityNormal();
                }
                return Messages.Trend_PriorityHigh();
            }
        };
        if (configuration.useBuildDateAsDomain()) {
            return new ToolTipAreaRenderer(toolTip);
        }
        return new AreaRenderer(url, toolTip);
    }

    private static final class UrlBuilder
    extends CategoryUrlBuilder {
        private static final long serialVersionUID = 3049511502830320036L;

        protected UrlBuilder(String rootUrl, String pluginName) {
            super(rootUrl, pluginName);
        }

        @Override
        protected String getDetailUrl(int row) {
            if (row == 0) {
                return Priority.LOW.name();
            }
            if (row == 1) {
                return Priority.NORMAL.name();
            }
            return Priority.HIGH.name();
        }
    }
}

