/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.graph;

import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.core.BuildHistory;
import hudson.plugins.analysis.graph.GraphConfiguration;
import hudson.plugins.analysis.graph.GraphConfigurationView;
import hudson.plugins.analysis.util.CookieHandler;
import javax.servlet.http.Cookie;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class UserGraphConfigurationView
extends GraphConfigurationView {
    public UserGraphConfigurationView(GraphConfiguration configuration, Job<?, ?> job, String jobActionUrl, String globalFileName, Cookie[] cookies, BuildHistory buildHistory) {
        super(configuration, job, jobActionUrl, buildHistory);
        if (!configuration.initializeFrom(UserGraphConfigurationView.createCookieHandler(jobActionUrl).getValue(cookies))) {
            configuration.initializeFromFile(UserGraphConfigurationView.createDefaultsFile(job, globalFileName));
        }
    }

    @Deprecated
    public UserGraphConfigurationView(GraphConfiguration configuration, AbstractProject<?, ?> project, String projectActionUrl, String globalFileName, Cookie[] cookies, BuildHistory buildHistory) {
        this(configuration, (Job<?, ?>)project, projectActionUrl, globalFileName, cookies, buildHistory);
    }

    public UserGraphConfigurationView(GraphConfiguration configuration, Job<?, ?> job, String jobActionUrl, Cookie[] cookies, BuildHistory buildHistory) {
        this(configuration, job, jobActionUrl, jobActionUrl, cookies, buildHistory);
    }

    @Deprecated
    public UserGraphConfigurationView(GraphConfiguration configuration, AbstractProject<?, ?> project, String projectActionUrl, Cookie[] cookies, BuildHistory buildHistory) {
        this(configuration, (Job<?, ?>)project, projectActionUrl, projectActionUrl, cookies, buildHistory);
    }

    protected static CookieHandler createCookieHandler(String cookieName) {
        return new CookieHandler(cookieName);
    }

    public String getDisplayName() {
        return Messages.UserGraphConfiguration_Name();
    }

    @Override
    public String getDescription() {
        return Messages.UserGraphConfiguration_Description();
    }

    public String getUrl() {
        return this.getOwner().getAbsoluteUrl() + "/" + this.getKey() + "/configure";
    }

    @Override
    protected void persistValue(String value, String pluginName, StaplerRequest request, StaplerResponse response) {
        Cookie cookie = UserGraphConfigurationView.createCookieHandler(pluginName).create(request.getAncestors(), value);
        response.addCookie(cookie);
    }
}

