/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.FilePath;
import hudson.model.TaskListener;
import hudson.plugins.analysis.util.BlameRequest;
import hudson.plugins.analysis.util.Blamer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.lang3.exception.ExceptionUtils;

public abstract class AbstractBlamer
implements Blamer {
    private final FilePath workspace;
    private final TaskListener listener;

    public AbstractBlamer(FilePath workspace, TaskListener listener) {
        this.workspace = workspace;
        this.listener = listener;
    }

    @Override
    public void blame(Set<FileAnnotation> annotations) {
        try {
            if (annotations.isEmpty()) {
                return;
            }
            this.invokeBlamer(annotations);
        }
        catch (IOException e) {
            this.error("Computing blame information failed with an exception:%n%s%n%s", e.getMessage(), ExceptionUtils.getStackTrace((Throwable)e));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void invokeBlamer(Set<FileAnnotation> annotations) throws IOException, InterruptedException {
        final Map<String, BlameRequest> linesOfConflictingFiles = this.extractConflictingFiles(annotations);
        Map blamesOfConflictingFiles = (Map)this.getWorkspace().act((FilePath.FileCallable)new MasterToSlaveFileCallable<Map<String, BlameRequest>>(){

            public Map<String, BlameRequest> invoke(File workspace, VirtualChannel channel) throws IOException, InterruptedException {
                return AbstractBlamer.this.blame(linesOfConflictingFiles);
            }
        });
        this.setBlameResults(annotations, blamesOfConflictingFiles);
    }

    private void setBlameResults(Set<FileAnnotation> annotations, Map<String, BlameRequest> blamesOfConflictingFiles) {
        for (FileAnnotation annotation : annotations) {
            if (blamesOfConflictingFiles.containsKey(annotation.getFileName())) {
                BlameRequest blame = blamesOfConflictingFiles.get(annotation.getFileName());
                int line = annotation.getPrimaryLineNumber();
                annotation.setAuthorName(blame.getName(line));
                annotation.setAuthorEmail(blame.getEmail(line));
                annotation.setCommitId(blame.getCommit(line));
                continue;
            }
            this.log("Skipping file %s, no result found.%n", annotation.getFileName());
        }
    }

    protected abstract Map<String, BlameRequest> blame(Map<String, BlameRequest> var1) throws InterruptedException, IOException;

    protected Map<String, BlameRequest> extractConflictingFiles(Set<FileAnnotation> annotations) {
        HashMap<String, BlameRequest> pathsByFileName = new HashMap<String, BlameRequest>();
        String workspacePath = this.getWorkspacePath();
        for (FileAnnotation annotation : annotations) {
            if (annotation.getPrimaryLineNumber() <= 0) continue;
            String storedFileName = annotation.getFileName();
            if (pathsByFileName.containsKey(storedFileName)) {
                BlameRequest blame = (BlameRequest)pathsByFileName.get(storedFileName);
                blame.addLineNumber(annotation.getPrimaryLineNumber());
                continue;
            }
            String absoluteFileName = this.getCanonicalPath(storedFileName);
            if (absoluteFileName.startsWith(workspacePath)) {
                String relativeFileName = absoluteFileName.substring(workspacePath.length());
                if (relativeFileName.startsWith("/") || relativeFileName.startsWith("\\")) {
                    relativeFileName = relativeFileName.substring(1);
                }
                pathsByFileName.put(storedFileName, new BlameRequest(relativeFileName, annotation.getPrimaryLineNumber()));
                continue;
            }
            this.log("Skipping non-workspace file %s (workspace = %s, absolute = %s.%n", storedFileName, workspacePath, absoluteFileName);
        }
        return pathsByFileName;
    }

    private String getWorkspacePath() {
        return this.getCanonicalPath(this.workspace.getRemote());
    }

    private String getCanonicalPath(String path) {
        try {
            return new File(path).getCanonicalPath().replace('\\', '/');
        }
        catch (IOException e) {
            return path;
        }
    }

    protected final void log(String message, Object ... args) {
        this.listener.getLogger().append("<Git Blamer> " + String.format(message, args));
    }

    protected final void error(String message, Object ... args) {
        this.listener.error("<Git Blamer> " + String.format(message, args));
    }

    protected FilePath getWorkspace() {
        return this.workspace;
    }

    protected TaskListener getListener() {
        return this.listener;
    }
}

