/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.analysis.util.Blamer;
import hudson.plugins.analysis.util.GitChecker;
import hudson.plugins.analysis.util.NullBlamer;
import hudson.scm.SCM;
import jenkins.model.Jenkins;

public class BlameFactory {
    public static Blamer createBlamer(Run<?, ?> run, FilePath workspace, TaskListener listener) {
        if (run instanceof AbstractBuild) {
            Jenkins instance;
            AbstractBuild build = (AbstractBuild)run;
            AbstractProject project = build.getProject();
            SCM scm = project.getScm();
            if (scm == null) {
                scm = project.getRootProject().getScm();
            }
            if ((instance = Jenkins.getInstance()).getPlugin("git") != null) {
                GitChecker gitChecker = new GitChecker();
                if (gitChecker.isGit(scm)) {
                    return gitChecker.createBlamer(build, scm, workspace, listener);
                }
                BlameFactory.logOnlyGitSupported(listener);
            } else {
                BlameFactory.logOnlyGitSupported(listener);
            }
        } else {
            BlameFactory.log(listener, "Skipping warnings blame since pipelines do not have an SCM link.%n");
        }
        return new NullBlamer();
    }

    private static void logOnlyGitSupported(TaskListener listener) {
        BlameFactory.log(listener, "Skipping warnings blame since Git is the only supported SCM up to now.%n");
    }

    private static void log(TaskListener listener, String message) {
        listener.getLogger().println(message);
    }
}

