/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class BlameRequest
implements Iterable<Integer>,
Serializable {
    private String fileName;
    private final Set<Integer> lines = new HashSet<Integer>();
    private final Map<Integer, String> commitByLine = new HashMap<Integer, String>();
    private final Map<Integer, String> nameByLine = new HashMap<Integer, String>();
    private final Map<Integer, String> emailByLine = new HashMap<Integer, String>();

    public BlameRequest(String fileName, int lineNumber) {
        this.fileName = fileName;
        this.addLineNumber(lineNumber);
    }

    public final void addLineNumber(int lineNumber) {
        this.lines.add(lineNumber);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        return this.fileName + " - " + this.lines;
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.lines.iterator();
    }

    public void setCommit(int line, String id) {
        this.commitByLine.put(line, id);
    }

    public String getCommit(int line) {
        return this.commitByLine.get(line);
    }

    public void setName(int line, String name) {
        this.nameByLine.put(line, name);
    }

    public String getName(int line) {
        return this.nameByLine.get(line);
    }

    public void setEmail(int line, String emailAddress) {
        this.emailByLine.put(line, emailAddress);
    }

    public String getEmail(int line) {
        return this.emailByLine.get(line);
    }
}

