/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.util.SerializableUrlGenerator;
import hudson.util.ChartUtil;
import org.apache.commons.lang.StringUtils;
import org.jfree.data.category.CategoryDataset;

public class CategoryUrlBuilder
implements SerializableUrlGenerator {
    private static final long serialVersionUID = -3383164939484624157L;
    private final String pluginName;
    private final String rootUrl;

    public CategoryUrlBuilder(String rootUrl, String pluginName) {
        this.rootUrl = rootUrl;
        this.pluginName = this.isBlank(pluginName) ? "" : "/" + pluginName + "Result/";
    }

    public String generateURL(CategoryDataset dataset, int row, int column) {
        String prefix = this.rootUrl + this.getLabel(dataset, column).getRun().getNumber();
        if (this.isBlank(this.pluginName)) {
            return prefix;
        }
        return prefix + this.pluginName + this.getDetailUrl(row);
    }

    private boolean isBlank(String value) {
        return StringUtils.isBlank((String)value);
    }

    public String getRootUrl() {
        return this.rootUrl;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    protected String getDetailUrl(int row) {
        return "";
    }

    private ChartUtil.NumberOnlyBuildLabel getLabel(CategoryDataset dataset, int column) {
        return (ChartUtil.NumberOnlyBuildLabel)dataset.getColumnKey(column);
    }
}

