/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;

public final class Compatibility {
    public static boolean isOverridden(@Nonnull Class base, @Nonnull Class derived, @Nonnull String methodName, Class ... types) {
        try {
            return !Compatibility.getMethod(base, methodName, types).equals(Compatibility.getMethod(derived, methodName, types));
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static Method getMethod(@Nonnull Class clazz, @Nonnull String methodName, Class ... types) throws NoSuchMethodException {
        Method res = null;
        try {
            res = clazz.getDeclaredMethod(methodName, types);
        }
        catch (NoSuchMethodException e) {
            Class superclass = clazz.getSuperclass();
            if (superclass != null) {
                res = Compatibility.getMethod(superclass, methodName, types);
            }
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e);
        }
        if (res == null) {
            throw new NoSuchMethodException("Method " + methodName + " not found in " + clazz.getName());
        }
        return res;
    }

    private Compatibility() {
    }
}

