/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import java.util.List;
import javax.servlet.http.Cookie;
import org.kohsuke.stapler.Ancestor;

public class CookieHandler {
    private static final int ANCESTOR_PATH_PREFIX = 3;
    private static final int ONE_YEAR = 31536000;
    private final String name;

    public CookieHandler(String name) {
        this.name = "hudson.plugins." + name;
    }

    public Cookie create(List<Ancestor> requestAncestors, String value) {
        Cookie cookie = new Cookie(this.name, value);
        Ancestor ancestor = requestAncestors.get(requestAncestors.size() - 3);
        cookie.setPath(ancestor.getUrl());
        cookie.setMaxAge(31536000);
        return cookie;
    }

    public String getValue(Cookie[] cookies) {
        String values = "";
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.name)) continue;
                values = cookie.getValue();
                break;
            }
        }
        return values;
    }
}

