/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.util.AbstractPackageDetector;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class CsharpNamespaceDetector
extends AbstractPackageDetector {
    @Override
    public boolean accepts(String fileName) {
        return fileName.endsWith(".cs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String detectPackageName(InputStream stream) {
        try {
            LineIterator iterator = IOUtils.lineIterator((InputStream)stream, (String)"UTF-8");
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                if (!line.matches("^namespace .*$")) continue;
                if (line.contains("{")) {
                    String string = StringUtils.substringBetween((String)line, (String)" ", (String)"{").trim();
                    return string;
                }
                String string = StringUtils.substringAfter((String)line, (String)" ").trim();
                return string;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return "-";
    }
}

