/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.Messages;
import hudson.plugins.analysis.util.Validator;
import hudson.util.FormValidation;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.StringUtils;

public class EncodingValidator
implements Validator {
    private static Set<String> allCharacterSets;

    public static Set<String> getAvailableCharsets() {
        return allCharacterSets;
    }

    public static Charset defaultCharset(@CheckForNull String defaultEncoding) {
        try {
            if (StringUtils.isNotBlank((String)defaultEncoding)) {
                return Charset.forName(defaultEncoding);
            }
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
            // empty catch block
        }
        return Charset.defaultCharset();
    }

    public static LineIterator readFile(String fileName, @CheckForNull String encoding) throws FileNotFoundException, IOException {
        FileInputStream stream = new FileInputStream(new File(fileName));
        if (StringUtils.isNotBlank((String)encoding)) {
            return IOUtils.lineIterator((InputStream)stream, (String)encoding);
        }
        return new LineIterator((Reader)new InputStreamReader((InputStream)stream, Charsets.toCharset((Charset)Charset.defaultCharset())));
    }

    @Override
    public FormValidation check(String encoding) throws FormValidation {
        try {
            if (StringUtils.isBlank((String)encoding) || Charset.forName(encoding).canEncode()) {
                return FormValidation.ok();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        throw FormValidation.error((String)Messages.FieldValidator_Error_DefaultEncoding());
    }

    public static String getEncoding(@CheckForNull String encoding) {
        if (StringUtils.isNotBlank((String)encoding) && Charset.forName(encoding).canEncode()) {
            return encoding;
        }
        return Charset.defaultCharset().name();
    }

    static {
        try {
            allCharacterSets = Collections.unmodifiableSet(new HashSet<String>(Charset.availableCharsets().keySet()));
        }
        catch (Exception exception) {
            allCharacterSets = Collections.emptySet();
        }
    }
}

