/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.FilePath;
import hudson.plugins.analysis.util.model.DefaultAnnotationContainer;
import hudson.plugins.analysis.util.model.FileAnnotation;
import hudson.plugins.analysis.util.model.WorkspaceFile;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collection;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class Files {
    private static final String SLASH = "/";

    public void copyFilesWithAnnotationsToBuildFolder(FilePath rootDir, Collection<FileAnnotation> annotations, String defaultEncoding) throws IOException, InterruptedException {
        this.copyFilesWithAnnotationsToBuildFolder(null, rootDir, annotations, defaultEncoding);
    }

    public void copyFilesWithAnnotationsToBuildFolder(VirtualChannel channel, FilePath rootDir, Collection<FileAnnotation> annotations, String defaultEncoding) throws IOException, InterruptedException {
        FilePath directory = rootDir.child("workspace-files");
        if (!directory.exists()) {
            try {
                directory.mkdirs();
            }
            catch (IOException exception) {
                throw new IOException("Can't create directory for workspace files that contain annotations: " + directory.getName(), exception);
            }
        }
        DefaultAnnotationContainer container = new DefaultAnnotationContainer(annotations);
        for (WorkspaceFile file : container.getFiles()) {
            FilePath masterFile = directory.child(file.getTempName());
            if (masterFile.exists()) continue;
            try {
                new FilePath(channel, file.getName()).copyTo(masterFile);
            }
            catch (IOException exception) {
                this.logExceptionToFile(exception, masterFile, file.getName(), defaultEncoding);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logExceptionToFile(IOException exception, FilePath masterFile, String slaveFileName, String defaultEncoding) throws InterruptedException {
        OutputStream outputStream = null;
        try {
            outputStream = masterFile.write();
            this.print(outputStream, defaultEncoding, "Copying the source file '%s' from the workspace to the build folder '%s' on the Jenkins master failed.%n", slaveFileName, masterFile.getName());
            if (!slaveFileName.startsWith(SLASH) && !slaveFileName.contains(":")) {
                this.print(outputStream, defaultEncoding, "Seems that the path is relative, however an absolute path is required when copying the sources.%n", new Object[0]);
                String base = slaveFileName.contains(SLASH) ? StringUtils.substringAfterLast((String)slaveFileName, (String)SLASH) : slaveFileName;
                this.print(outputStream, defaultEncoding, "Is the file '%s' contained more than once in your workspace?%n", base);
            }
            this.print(outputStream, defaultEncoding, "Is the file '%s' a valid filename?%n", slaveFileName);
            this.print(outputStream, defaultEncoding, "If you are building on a slave: please check if the file is accessible under '$JENKINS_HOME/[job-name]/%s'%n", slaveFileName);
            this.print(outputStream, defaultEncoding, "If you are building on the master: please check if the file is accessible under '$JENKINS_HOME/[job-name]/workspace/%s'%n", slaveFileName);
            exception.printStackTrace(new PrintStream(outputStream, false, defaultEncoding));
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtils.closeQuietly((OutputStream)outputStream);
        }
    }

    private void print(OutputStream outputStream, String defaultEncoding, String message, Object ... arguments) throws IOException {
        IOUtils.write((String)String.format(message, arguments), (OutputStream)outputStream, (String)defaultEncoding);
    }
}

