/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.model.TaskListener;
import hudson.plugins.analysis.util.AbstractBlamer;
import hudson.plugins.analysis.util.BlameRequest;
import hudson.plugins.git.GitException;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.api.BlameCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.blame.BlameResult;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.jenkinsci.plugins.gitclient.RepositoryCallback;

public class GitBlamer
extends AbstractBlamer {
    private final GitClient git;
    private final String gitCommit;

    public GitBlamer(GitClient git, @CheckForNull String gitCommit, TaskListener listener) {
        super(git.getWorkTree(), listener);
        this.git = git;
        this.gitCommit = StringUtils.defaultString((String)gitCommit, (String)"HEAD");
        this.log("Using GitBlamer to create author and commit information for all warnings.%n", new Object[0]);
        this.log("GIT_COMMIT=%s, workspace=%s%n", gitCommit, git.getWorkTree());
    }

    @Override
    protected Map<String, BlameRequest> blame(Map<String, BlameRequest> linesOfConflictingFiles) throws InterruptedException, IOException {
        return this.fillBlameResults(linesOfConflictingFiles, this.loadBlameResultsForFiles(linesOfConflictingFiles));
    }

    private Map<String, BlameResult> loadBlameResultsForFiles(Map<String, BlameRequest> linesOfConflictingFiles) throws InterruptedException, IOException {
        try {
            ObjectId headCommit = this.git.revParse(this.gitCommit);
            return (Map)this.git.withRepository((RepositoryCallback)new BlameCallback(this, headCommit, linesOfConflictingFiles.values()));
        }
        catch (GitException exception) {
            this.log("Can't determine head commit using 'git rev-parse'. Skipping blame. %n%s%n", exception.getMessage());
            return Collections.emptyMap();
        }
    }

    private Map<String, BlameRequest> fillBlameResults(Map<String, BlameRequest> linesOfConflictingFiles, Map<String, BlameResult> blameResults) {
        for (String fileName : linesOfConflictingFiles.keySet()) {
            BlameRequest request = linesOfConflictingFiles.get(fileName);
            BlameResult blame = blameResults.get(request.getFileName());
            if (blame == null) {
                this.log("No blame details found for %s.%n", fileName);
                continue;
            }
            for (int line : request) {
                int lineIndex = line - 1;
                if (lineIndex >= blame.getResultContents().size()) continue;
                PersonIdent who = blame.getSourceAuthor(lineIndex);
                if (who == null) {
                    this.log("No author information found for line %d in file %s.%n", lineIndex, fileName);
                } else {
                    request.setName(line, who.getName());
                    request.setEmail(line, who.getEmailAddress());
                }
                RevCommit commit = blame.getSourceCommit(lineIndex);
                if (commit == null) {
                    this.log("No commit ID found for line %d in file %s.%n", lineIndex, fileName);
                    continue;
                }
                request.setCommit(line, commit.getName());
            }
        }
        return linesOfConflictingFiles;
    }

    private static class BlameCallback
    implements RepositoryCallback<Map<String, BlameResult>> {
        private GitBlamer gitBlamer;
        private ObjectId headCommit;
        private Collection<BlameRequest> requests;

        public BlameCallback(GitBlamer gitBlamer, ObjectId headCommit, Collection<BlameRequest> requests) {
            this.gitBlamer = gitBlamer;
            this.headCommit = headCommit;
            this.requests = requests;
        }

        public Map<String, BlameResult> invoke(Repository repo, VirtualChannel channel) throws IOException, InterruptedException {
            HashMap<String, BlameResult> blameResults = new HashMap<String, BlameResult>();
            if (this.headCommit == null) {
                this.gitBlamer.error("Could not retrieve HEAD commit, aborting.", new Object[0]);
                return blameResults;
            }
            for (BlameRequest request : this.requests) {
                String message;
                BlameCommand blame = new BlameCommand(repo);
                String fileName = request.getFileName();
                blame.setFilePath(fileName);
                blame.setStartCommit((AnyObjectId)this.headCommit);
                try {
                    BlameResult result = blame.call();
                    if (result == null) {
                        this.gitBlamer.log("No blame results for request <%s>.%n", request);
                    } else {
                        blameResults.put(fileName, result);
                    }
                    if (!Thread.interrupted()) continue;
                    message = "Thread was interrupted while computing blame information.";
                    this.gitBlamer.log(message, new Object[0]);
                    throw new InterruptedException(message);
                }
                catch (GitAPIException e) {
                    message = "Error running git blame on " + fileName + " with revision: " + this.headCommit;
                    this.gitBlamer.error(message, new Object[0]);
                }
            }
            return blameResults;
        }
    }
}

