/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.analysis.util.Blamer;
import hudson.plugins.analysis.util.GitBlamer;
import hudson.plugins.analysis.util.NullBlamer;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import java.io.IOException;
import org.jenkinsci.plugins.gitclient.GitClient;

public class GitChecker {
    public boolean isGit(SCM scm) {
        return scm instanceof GitSCM;
    }

    public Blamer createBlamer(AbstractBuild build, SCM scm, FilePath workspace, TaskListener listener) {
        try {
            GitClient gitClient = this.asGit(scm).createClient(listener, this.getEnvironment(build, listener), (Run)build, workspace);
            String gitCommit = (String)this.getEnvironment(build, listener).get((Object)"GIT_COMMIT");
            return new GitBlamer(gitClient, gitCommit, listener);
        }
        catch (IOException e) {
            return new NullBlamer();
        }
        catch (InterruptedException e) {
            return new NullBlamer();
        }
    }

    private EnvVars getEnvironment(AbstractBuild build, TaskListener listener) {
        try {
            return build.getEnvironment(listener);
        }
        catch (IOException iOException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new EnvVars();
    }

    private GitSCM asGit(SCM scm) {
        return (GitSCM)scm;
    }
}

