/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.util.AbstractPackageDetector;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;

public class JavaPackageDetector
extends AbstractPackageDetector {
    private final Pattern pattern = Pattern.compile("^\\s*package\\s*([a-z]+(\\.[a-zA-Z_][a-zA-Z0-9_]*)*)\\s*;.*");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String detectPackageName(InputStream stream) {
        try {
            LineIterator iterator = new LineIterator((Reader)new InputStreamReader(stream, Charsets.toCharset((Charset)Charset.defaultCharset())));
            while (iterator.hasNext()) {
                String line = iterator.nextLine();
                Matcher matcher = this.pattern.matcher(line);
                if (!matcher.matches()) continue;
                String string = matcher.group(1);
                return string;
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
        return "-";
    }

    @Override
    public boolean accepts(String fileName) {
        return fileName.endsWith(".java");
    }
}

