/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.util.FileFinder;
import hudson.plugins.analysis.util.FileInputStreamFactory;
import hudson.plugins.analysis.util.SecureDigester;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class ModuleDetector {
    private static final String PLUS = ", ";
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";
    private static final String ALL_DIRECTORIES = "**/";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String REPLACEMENT_CHAR = "%";
    static final String MAVEN_POM = "pom.xml";
    static final String ANT_PROJECT = "build.xml";
    static final String OSGI_BUNDLE = "META-INF/MANIFEST.MF";
    private static final String PATTERN = "**/pom.xml, **/build.xml, **/META-INF/MANIFEST.MF";
    private FileInputStreamFactory factory = new DefaultFileInputStreamFactory();
    private final Map<String, String> fileNameToModuleName;
    private final List<String> prefixes;

    protected ModuleDetector() {
        this.fileNameToModuleName = new HashMap<String, String>();
        this.prefixes = new ArrayList<String>();
    }

    public ModuleDetector(File workspace) {
        this(workspace, new DefaultFileInputStreamFactory());
    }

    ModuleDetector(File workspace, FileInputStreamFactory fileInputStreamFactory) {
        this.factory = fileInputStreamFactory;
        this.fileNameToModuleName = this.createFilesToModuleMapping(workspace);
        this.prefixes = new ArrayList<String>(this.fileNameToModuleName.keySet());
        Collections.sort(this.prefixes);
    }

    private Map<String, String> createFilesToModuleMapping(File workspace) {
        String[] projects;
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String fileName : projects = this.find(workspace)) {
            if (!fileName.endsWith(ANT_PROJECT)) continue;
            this.addMapping(mapping, fileName, ANT_PROJECT, this.parseBuildXml(fileName));
        }
        for (String fileName : projects) {
            if (!fileName.endsWith(MAVEN_POM)) continue;
            this.addMapping(mapping, fileName, MAVEN_POM, this.parsePom(fileName));
        }
        for (String fileName : projects) {
            if (!fileName.endsWith(OSGI_BUNDLE)) continue;
            this.addMapping(mapping, fileName, OSGI_BUNDLE, this.parseManifest(fileName));
        }
        return mapping;
    }

    private void addMapping(Map<String, String> mapping, String fileName, String suffix, String moduleName) {
        if (StringUtils.isNotBlank((String)moduleName)) {
            mapping.put(StringUtils.substringBeforeLast((String)fileName, (String)suffix), moduleName);
        }
    }

    public String guessModuleName(String originalFileName) {
        String fullPath = originalFileName.replace('\\', '/');
        String guessedModule = "";
        for (String path : this.prefixes) {
            if (!fullPath.startsWith(path)) continue;
            guessedModule = this.fileNameToModuleName.get(path);
        }
        return guessedModule;
    }

    private String[] find(File path) {
        String[] relativeFileNames = this.factory.find(path, PATTERN);
        String[] absoluteFileNames = new String[relativeFileNames.length];
        String absolutePath = this.normalizePath(path.getAbsolutePath());
        for (int file = 0; file < absoluteFileNames.length; ++file) {
            String relativePath = this.normalizePath(relativeFileNames[file]);
            absoluteFileNames[file] = relativePath.startsWith(SLASH) ? relativePath : absolutePath + SLASH + relativePath;
        }
        return absoluteFileNames;
    }

    private String normalizePath(String fileName) {
        return fileName.replace(BACK_SLASH, SLASH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String parseBuildXml(String buildXml) {
        String string;
        InputStream file = null;
        try {
            file = this.factory.create(buildXml);
            SecureDigester digester = new SecureDigester(ModuleDetector.class);
            digester.push(new StringBuffer());
            String xPath = "project";
            digester.addCallMethod(xPath, "append", 1);
            digester.addCallParam(xPath, 0, "name");
            StringBuffer result = (StringBuffer)digester.parse(file);
            string = result.toString();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(file);
            return "";
        }
        catch (SAXException sAXException) {
            IOUtils.closeQuietly(file);
            return "";
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(file);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)file);
        return string;
    }

    private String parsePom(String pom) {
        String name = this.parsePomAttribute(pom, "name");
        return StringUtils.defaultIfBlank((String)name, (String)this.parsePomAttribute(pom, "artifactId"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private String parsePomAttribute(String pom, String tagName) {
        String string;
        InputStream file = null;
        try {
            file = this.factory.create(pom);
            SecureDigester digester = new SecureDigester(ModuleDetector.class);
            digester.push(new StringBuffer());
            digester.addCallMethod("project/" + tagName, "append", 0);
            StringBuffer result = (StringBuffer)digester.parse(file);
            string = result.toString();
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly((InputStream)file);
        }
        catch (SAXException sAXException) {
            IOUtils.closeQuietly((InputStream)file);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(file);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)file);
        return string;
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String parseManifest(String manifestFile) {
        block5: {
            String string;
            Properties properties;
            Attributes attributes;
            InputStream file;
            block4: {
                file = null;
                file = this.factory.create(manifestFile);
                Manifest manifest = new Manifest(file);
                attributes = manifest.getMainAttributes();
                properties = this.readProperties(StringUtils.substringBefore((String)manifestFile, (String)OSGI_BUNDLE));
                String name = this.getLocalizedValue(attributes, properties, BUNDLE_NAME);
                if (!StringUtils.isNotBlank((String)name)) break block4;
                String string2 = name;
                IOUtils.closeQuietly((InputStream)file);
                return string2;
            }
            try {
                string = this.getSymbolicName(attributes, properties);
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(file);
                break block5;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(file);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)file);
            return string;
        }
        return "";
    }

    private String getLocalizedValue(Attributes attributes, Properties properties, String bundleName) {
        String value = attributes.getValue(bundleName);
        if (StringUtils.startsWith((String)StringUtils.trim((String)value), (String)REPLACEMENT_CHAR)) {
            return properties.getProperty(StringUtils.substringAfter((String)value, (String)REPLACEMENT_CHAR));
        }
        return value;
    }

    private Properties readProperties(String path) {
        Properties properties = new Properties();
        this.readProperties(path, properties, "plugin.properties");
        this.readProperties(path, properties, "OSGI-INF/l10n/bundle.properties");
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void readProperties(String path, Properties properties, String fileName) {
        InputStream file;
        block4: {
            file = null;
            try {
                file = this.factory.create(path + SLASH + fileName);
                if (file == null) break block4;
                properties.load(file);
            }
            catch (IOException iOException) {
                IOUtils.closeQuietly(file);
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(file);
                    throw throwable;
                }
            }
        }
        IOUtils.closeQuietly((InputStream)file);
    }

    private String getSymbolicName(Attributes attributes, Properties properties) {
        String symbolicName = StringUtils.substringBefore((String)attributes.getValue(BUNDLE_SYMBOLIC_NAME), (String)";");
        if (StringUtils.isNotBlank((String)symbolicName)) {
            String vendor = this.getLocalizedValue(attributes, properties, BUNDLE_VENDOR);
            if (StringUtils.isNotBlank((String)vendor)) {
                return symbolicName + " (" + vendor + ")";
            }
            return symbolicName;
        }
        return "";
    }

    private static final class DefaultFileInputStreamFactory
    implements FileInputStreamFactory {
        private DefaultFileInputStreamFactory() {
        }

        @Override
        public InputStream create(String fileName) throws FileNotFoundException {
            return new FileInputStream(new File(fileName));
        }

        @Override
        public String[] find(File root, String pattern) {
            return new FileFinder(ModuleDetector.PATTERN).find(root);
        }
    }
}

