/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.analysis.util;

import hudson.plugins.analysis.util.AbstractPackageDetector;
import hudson.plugins.analysis.util.CsharpNamespaceDetector;
import hudson.plugins.analysis.util.JavaPackageDetector;
import hudson.plugins.analysis.util.PackageDetector;
import java.util.Arrays;
import java.util.List;

public final class PackageDetectors {
    public static final String UNDEFINED_PACKAGE = "-";
    private static final List<AbstractPackageDetector> DETECTORS = Arrays.asList(new JavaPackageDetector(), new CsharpNamespaceDetector());

    public static String detectPackageName(String fileName) {
        for (PackageDetector packageDetector : DETECTORS) {
            if (!packageDetector.accepts(fileName)) continue;
            return packageDetector.detectPackageName(fileName);
        }
        return UNDEFINED_PACKAGE;
    }

    private PackageDetectors() {
    }
}

